/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.build;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.build.AbstractSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public abstract class AbstractOrigin<T, B extends AbstractOrigin<T, B>>
extends AbstractSupplier<T, B> {
    final T origin;

    protected AbstractOrigin(T t2) {
        this.origin = Objects.requireNonNull(t2, "origin");
    }

    public T get() {
        return this.origin;
    }

    public InputStream getInputStream(OpenOption ... openOptionArray) throws IOException {
        return Files.newInputStream(this.getPath(), openOptionArray);
    }

    public Path getPath() {
        throw new UnsupportedOperationException(String.format("%s#getPath() for %s origin %s", this.getClass().getSimpleName(), this.origin.getClass().getSimpleName(), this.origin));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.origin.toString() + "]";
    }

    public static class PathOrigin
    extends AbstractOrigin<Path, PathOrigin> {
        public PathOrigin(Path path) {
            super(path);
        }

        @Override
        public Path getPath() {
            return (Path)this.get();
        }
    }
}

