/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.scan.extension.a.d;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginExecutionException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Singleton
@Component(role=BuildPluginManager.class)
public final class a
implements BuildPluginManager {
    private final MavenPluginManager a;
    private final LegacySupport b;
    private final MojoExecutionScope c;
    private MojoExecutionListener d;

    @Inject
    public a(MavenPluginManager mavenPluginManager, LegacySupport legacySupport, MojoExecutionScope scope, List<MojoExecutionListener> mojoExecutionListeners) {
        this.a = mavenPluginManager;
        this.b = legacySupport;
        this.c = scope;
        this.d = new a(mojoExecutionListeners);
    }

    public PluginDescriptor loadPlugin(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        return this.a.getPluginDescriptor(plugin, repositories, session);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeMojo(MavenSession session, MojoExecution mojoExecution) throws MojoFailureException, MojoExecutionException, PluginConfigurationException, PluginManagerException {
        ClassRealm pluginRealm;
        MavenProject project = session.getCurrentProject();
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Mojo mojo = null;
        try {
            pluginRealm = this.getPluginRealm(session, mojoDescriptor.getPluginDescriptor());
        }
        catch (PluginResolutionException e2) {
            throw new PluginExecutionException(mojoExecution, project, (Exception)((Object)e2));
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)pluginRealm);
        MavenSession oldSession = this.b.getSession();
        this.c.enter();
        try {
            this.c.seed(MavenProject.class, (Object)project);
            this.c.seed(MojoExecution.class, (Object)mojoExecution);
            mojo = (Mojo)this.a.getConfiguredMojo(Mojo.class, session, mojoExecution);
            this.b.setSession(session);
            try {
                MojoExecutionEvent mojoExecutionEvent = new MojoExecutionEvent(session, project, mojoExecution, mojo);
                this.d.beforeMojoExecution(mojoExecutionEvent);
                mojo.execute();
                this.d.afterMojoExecutionSuccess(mojoExecutionEvent);
            }
            catch (ClassCastException e3) {
                throw e3;
            }
            catch (RuntimeException e4) {
                throw new PluginExecutionException(mojoExecution, project, (Exception)e4);
            }
        }
        catch (PluginContainerException e5) {
            try {
                this.d.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, (Throwable)e5));
                throw new PluginExecutionException(mojoExecution, project, (Exception)((Object)e5));
                catch (NoClassDefFoundError e6) {
                    this.d.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, (Throwable)e6));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("A required class was missing while executing " + mojoDescriptor.getId() + ": " + e6.getMessage());
                    pluginRealm.display(ps);
                    PluginContainerException wrapper = new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), (Throwable)e6);
                    throw new PluginExecutionException(mojoExecution, project, (Exception)((Object)wrapper));
                }
                catch (LinkageError e7) {
                    this.d.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, (Throwable)e7));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("An API incompatibility was encountered while executing " + mojoDescriptor.getId() + ": " + e7.getClass().getName() + ": " + e7.getMessage());
                    pluginRealm.display(ps);
                    PluginContainerException wrapper = new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), (Throwable)e7);
                    throw new PluginExecutionException(mojoExecution, project, (Exception)((Object)wrapper));
                }
                catch (ClassCastException e8) {
                    this.d.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, (Throwable)e8));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("A type incompatibility occurred while executing " + mojoDescriptor.getId() + ": " + e8.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginExecutionException(mojoExecution, project, os.toString(), (Throwable)e8);
                }
                catch (RuntimeException | MojoExecutionException | MojoFailureException e9) {
                    this.d.afterExecutionFailure(new MojoExecutionEvent(session, project, mojoExecution, mojo, e9));
                    throw e9;
                }
            }
            catch (Throwable throwable) {
                this.a.releaseMojo(mojo, mojoExecution);
                this.c.exit();
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.b.setSession(oldSession);
                throw throwable;
            }
        }
        this.a.releaseMojo((Object)mojo, mojoExecution);
        this.c.exit();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        this.b.setSession(oldSession);
    }

    public ClassRealm getPluginRealm(MavenSession session, PluginDescriptor pluginDescriptor) throws PluginResolutionException, PluginManagerException {
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (pluginRealm != null) {
            return pluginRealm;
        }
        this.a.setupPluginRealm(pluginDescriptor, session, null, null, null);
        return pluginDescriptor.getClassRealm();
    }

    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        return this.a.getMojoDescriptor(plugin, goal, repositories, session);
    }

    private static final class a
    implements MojoExecutionListener {
        private final Collection<MojoExecutionListener> a;

        a(Collection<MojoExecutionListener> listeners) {
            this.a = listeners;
        }

        public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
            for (MojoExecutionListener listener : this.a) {
                listener.beforeMojoExecution(event);
            }
        }

        public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
            for (MojoExecutionListener listener : this.a) {
                listener.afterMojoExecutionSuccess(event);
            }
        }

        public void afterExecutionFailure(MojoExecutionEvent event) {
            for (MojoExecutionListener listener : this.a) {
                listener.afterExecutionFailure(event);
            }
        }
    }
}

