/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;

public class DefaultBuildCacheTempFileStore
implements BuildCacheTempFileStore {
    private final File dir;

    public DefaultBuildCacheTempFileStore(File dir) {
        this.dir = dir;
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withTempFile(BuildCacheKey key, Consumer<? super File> action) {
        String hashCode = key.getHashCode();
        File tempFile = null;
        try {
            try {
                tempFile = File.createTempFile(hashCode + "-", ".part", this.dir);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            action.accept(tempFile);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tempFile);
            throw throwable;
        }
        FileUtils.deleteQuietly(tempFile);
    }
}

