/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi;

import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.TextColor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.Visitor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.BackgroundColor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.BoldOff;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.BoldOn;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CarriageReturn;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorBackward;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorDown;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorForward;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.CursorUp;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.EraseInLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.EraseToBeginningOfLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.EraseToEndOfLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.ForegroundColor;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.NewLine;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.Text;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.Token;
import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.token.UnrecognizedControlSequence;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class AnsiParser {
    public OutputStream newParser(String charset, Visitor visitor) {
        try {
            Charset encoding = Charset.forName(charset);
            return new ParsingStream(new AnsiByteConsumer(encoding, visitor));
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not parse input", e2);
        }
    }

    private static void split(String string, Visitor visitor) {
        int pos = 0;
        while (pos < string.length()) {
            int endToken;
            if (string.charAt(pos) == '\n') {
                visitor.visit(NewLine.INSTANCE);
                ++pos;
                continue;
            }
            if (string.charAt(pos) == '\r') {
                visitor.visit(CarriageReturn.INSTANCE);
                ++pos;
                continue;
            }
            for (endToken = pos; endToken < string.length() && string.charAt(endToken) != '\n' && string.charAt(endToken) != '\r'; ++endToken) {
            }
            visitor.visit(new Text(string.substring(pos, endToken)));
            pos = endToken;
        }
    }

    private static boolean parse(String params, char code, Visitor visitor) {
        if (code == 'A') {
            if (params.isEmpty()) {
                visitor.visit(new CursorUp(1));
            } else {
                visitor.visit(new CursorUp(Integer.parseInt(params)));
            }
            return true;
        }
        if (code == 'B') {
            if (params.isEmpty()) {
                visitor.visit(new CursorDown(1));
            } else {
                visitor.visit(new CursorDown(Integer.parseInt(params)));
            }
            return true;
        }
        if (code == 'C') {
            if (params.isEmpty()) {
                visitor.visit(new CursorForward(1));
            } else {
                visitor.visit(new CursorForward(Integer.parseInt(params)));
            }
            return true;
        }
        if (code == 'D') {
            if (params.isEmpty()) {
                visitor.visit(new CursorBackward(1));
            } else {
                visitor.visit(new CursorBackward(Integer.parseInt(params)));
            }
            return true;
        }
        if (code == 'K') {
            if (params.isEmpty() || params.equals("0")) {
                visitor.visit(EraseToEndOfLine.INSTANCE);
                return true;
            }
            if (params.equals("1")) {
                visitor.visit(EraseToBeginningOfLine.INSTANCE);
                return true;
            }
            if (params.equals("2")) {
                visitor.visit(EraseInLine.INSTANCE);
                return true;
            }
        }
        if (code == 'm') {
            if (params.isEmpty()) {
                visitor.visit(ForegroundColor.DEFAULT);
                visitor.visit(BackgroundColor.DEFAULT);
                visitor.visit(BoldOff.INSTANCE);
                return true;
            }
            if (params.contains(";")) {
                int pos = 0;
                CollectingVisitor collectingVisitor = new CollectingVisitor();
                while (pos < params.length()) {
                    int end = params.indexOf(59, pos);
                    if (end < 0) {
                        end = params.length();
                    } else if (end == pos) {
                        return false;
                    }
                    String attr = params.substring(pos, end);
                    if (!AnsiParser.parseTextAttribute(attr, collectingVisitor)) {
                        return false;
                    }
                    if (end == params.length() - 1) {
                        return false;
                    }
                    pos = end + 1;
                }
                for (Token token : collectingVisitor.tokens) {
                    visitor.visit(token);
                }
                return true;
            }
            if (AnsiParser.parseTextAttribute(params, visitor)) {
                return true;
            }
        }
        return false;
    }

    private static boolean parseTextAttribute(String params, Visitor visitor) {
        if (params.equals("0")) {
            visitor.visit(ForegroundColor.DEFAULT);
            visitor.visit(BackgroundColor.DEFAULT);
            visitor.visit(BoldOff.INSTANCE);
            return true;
        }
        if (params.equals("1")) {
            visitor.visit(BoldOn.INSTANCE);
            return true;
        }
        if (params.equals("22")) {
            visitor.visit(BoldOff.INSTANCE);
            return true;
        }
        if (params.equals("39")) {
            visitor.visit(ForegroundColor.DEFAULT);
            return true;
        }
        if (params.equals("30")) {
            visitor.visit(ForegroundColor.of(TextColor.BLACK));
            return true;
        }
        if (params.equals("31")) {
            visitor.visit(ForegroundColor.of(TextColor.RED));
            return true;
        }
        if (params.equals("32")) {
            visitor.visit(ForegroundColor.of(TextColor.GREEN));
            return true;
        }
        if (params.equals("33")) {
            visitor.visit(ForegroundColor.of(TextColor.YELLOW));
            return true;
        }
        if (params.equals("34")) {
            visitor.visit(ForegroundColor.of(TextColor.BLUE));
            return true;
        }
        if (params.equals("35")) {
            visitor.visit(ForegroundColor.of(TextColor.MAGENTA));
            return true;
        }
        if (params.equals("36")) {
            visitor.visit(ForegroundColor.of(TextColor.CYAN));
            return true;
        }
        if (params.equals("37")) {
            visitor.visit(ForegroundColor.of(TextColor.WHITE));
            return true;
        }
        if (params.equals("90")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_BLACK));
            return true;
        }
        if (params.equals("91")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_RED));
            return true;
        }
        if (params.equals("92")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_GREEN));
            return true;
        }
        if (params.equals("93")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_YELLOW));
            return true;
        }
        if (params.equals("94")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_BLUE));
            return true;
        }
        if (params.equals("95")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_MAGENTA));
            return true;
        }
        if (params.equals("96")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_CYAN));
            return true;
        }
        if (params.equals("97")) {
            visitor.visit(ForegroundColor.of(TextColor.BRIGHT_WHITE));
            return true;
        }
        if (params.equals("40")) {
            visitor.visit(BackgroundColor.of(TextColor.BLACK));
            return true;
        }
        if (params.equals("41")) {
            visitor.visit(BackgroundColor.of(TextColor.RED));
            return true;
        }
        if (params.equals("42")) {
            visitor.visit(BackgroundColor.of(TextColor.GREEN));
            return true;
        }
        if (params.equals("43")) {
            visitor.visit(BackgroundColor.of(TextColor.YELLOW));
            return true;
        }
        if (params.equals("44")) {
            visitor.visit(BackgroundColor.of(TextColor.BLUE));
            return true;
        }
        if (params.equals("45")) {
            visitor.visit(BackgroundColor.of(TextColor.MAGENTA));
            return true;
        }
        if (params.equals("46")) {
            visitor.visit(BackgroundColor.of(TextColor.CYAN));
            return true;
        }
        if (params.equals("47")) {
            visitor.visit(BackgroundColor.of(TextColor.WHITE));
            return true;
        }
        if (params.equals("49")) {
            visitor.visit(BackgroundColor.DEFAULT);
            return true;
        }
        if (params.equals("100")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_BLACK));
            return true;
        }
        if (params.equals("101")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_RED));
            return true;
        }
        if (params.equals("102")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_GREEN));
            return true;
        }
        if (params.equals("103")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_YELLOW));
            return true;
        }
        if (params.equals("104")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_BLUE));
            return true;
        }
        if (params.equals("105")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_MAGENTA));
            return true;
        }
        if (params.equals("106")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_CYAN));
            return true;
        }
        if (params.equals("107")) {
            visitor.visit(BackgroundColor.of(TextColor.BRIGHT_WHITE));
            return true;
        }
        return false;
    }

    private static class CollectingVisitor
    implements Visitor {
        final List<Token> tokens = new ArrayList<Token>();

        private CollectingVisitor() {
        }

        @Override
        public void visit(Token token) {
            this.tokens.add(token);
        }
    }

    private static class Buffer {
        private final byte[] buffer;
        private int offset;
        private int length;

        Buffer(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        String consumeString(Charset charset) {
            return new String(this.buffer, this.offset, this.length, charset);
        }

        byte peek() {
            return this.buffer[this.offset];
        }

        void consume() {
            ++this.offset;
            --this.length;
        }

        boolean hasMore() {
            return this.length > 0;
        }

        Buffer consumeToNext(byte value) {
            int maxOffset = this.offset + this.length;
            for (int nextValue = this.offset; nextValue < maxOffset; ++nextValue) {
                if (this.buffer[nextValue] != value) continue;
                int count = nextValue - this.offset;
                Buffer result = new Buffer(this.buffer, this.offset, count);
                this.offset = nextValue;
                this.length -= count;
                return result;
            }
            return null;
        }
    }

    private static class AnsiByteConsumer {
        private final StringBuilder currentSequence = new StringBuilder();
        private final Charset charset;
        private final Visitor visitor;
        private State state = State.Normal;

        AnsiByteConsumer(Charset charset, Visitor visitor) {
            this.charset = charset;
            this.visitor = visitor;
        }

        void consume(Buffer buffer) {
            block6: while (buffer.hasMore()) {
                switch (this.state) {
                    case LeftParen: {
                        if (buffer.peek() != 91) {
                            this.visitor.visit(new UnrecognizedControlSequence(""));
                            this.state = State.Normal;
                            continue block6;
                        }
                        buffer.consume();
                        this.state = State.Param;
                        continue block6;
                    }
                    case Param: {
                        byte nextDigit = buffer.peek();
                        if ((nextDigit < 48 || nextDigit > 57) && nextDigit != 59) {
                            this.state = State.Code;
                            continue block6;
                        }
                        this.currentSequence.append((char)nextDigit);
                        buffer.consume();
                        continue block6;
                    }
                    case Code: {
                        char next = (char)buffer.peek();
                        if (next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z') {
                            buffer.consume();
                            if (!AnsiParser.parse(this.currentSequence.toString(), next, this.visitor)) {
                                this.visitor.visit(new UnrecognizedControlSequence("[" + this.currentSequence.toString() + next));
                            }
                        } else {
                            this.visitor.visit(new UnrecognizedControlSequence("[" + this.currentSequence.toString()));
                        }
                        this.currentSequence.setLength(0);
                        this.state = State.Normal;
                        continue block6;
                    }
                    case Normal: {
                        Buffer prefix = buffer.consumeToNext((byte)27);
                        if (prefix == null) {
                            AnsiParser.split(buffer.consumeString(this.charset), this.visitor);
                            return;
                        }
                        AnsiParser.split(prefix.consumeString(this.charset), this.visitor);
                        this.state = State.LeftParen;
                        buffer.consume();
                        this.currentSequence.setLength(0);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    static enum State {
        Normal,
        LeftParen,
        Param,
        Code;

    }

    private static class ParsingStream
    extends OutputStream {
        private final AnsiByteConsumer sink;

        ParsingStream(AnsiByteConsumer sink) {
            this.sink = sink;
        }

        @Override
        public void write(int i2) throws IOException {
            byte[] buffer = new byte[]{(byte)i2};
            this.write(buffer, 0, 1);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            AnsiByteConsumer ansiByteConsumer = this.sink;
            synchronized (ansiByteConsumer) {
                this.sink.consume(new Buffer(bytes, offset, length));
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

