/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.internal.snapshot.SnapshottingFilter;

public class FileSystemSnapshotFilter {
    public static FileSystemSnapshot filterSnapshot(final SnapshottingFilter.FileSystemSnapshotPredicate predicate, FileSystemSnapshot unfiltered) {
        final MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        final AtomicBoolean hasBeenFiltered = new AtomicBoolean(false);
        unfiltered.accept(new FileSystemSnapshotVisitor(){
            private final RelativePathSegmentsTracker d = new RelativePathSegmentsTracker();

            @Override
            public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                boolean root = this.d.isRoot();
                this.d.enter(directorySnapshot);
                if (root || predicate.test(directorySnapshot, this.d.getRelativePath())) {
                    builder.preVisitDirectory(directorySnapshot);
                    return true;
                }
                hasBeenFiltered.set(true);
                this.d.leave();
                return false;
            }

            @Override
            public void visitFile(FileSystemLocationSnapshot fileSnapshot) {
                Iterable<String> relativePathForFiltering;
                boolean root = this.d.isRoot();
                this.d.enter(fileSnapshot);
                Iterable<String> iterable = relativePathForFiltering = root ? ImmutableList.of(fileSnapshot.getName()) : this.d.getRelativePath();
                if (predicate.test(fileSnapshot, relativePathForFiltering)) {
                    builder.visitFile(fileSnapshot);
                } else {
                    hasBeenFiltered.set(true);
                }
                this.d.leave();
            }

            @Override
            public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                this.d.leave();
                builder.postVisitDirectory();
            }
        });
        if (builder.getResult() == null) {
            return FileSystemSnapshot.EMPTY;
        }
        return hasBeenFiltered.get() ? builder.getResult() : unfiltered;
    }
}

