/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.file;

import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Arrays;

public class RelativePath
implements Serializable,
CharSequence,
Comparable<RelativePath> {
    public static final RelativePath EMPTY_ROOT = new RelativePath(false, new String[0]);
    private final boolean endsWithFile;
    private final String[] segments;

    public RelativePath(boolean endsWithFile, String ... segments) {
        this(endsWithFile, (RelativePath)null, segments);
    }

    private RelativePath(boolean endsWithFile, RelativePath parentPath, String ... childSegments) {
        int targetOffsetForChildSegments;
        this.endsWithFile = endsWithFile;
        if (parentPath != null) {
            String[] sourceSegments = parentPath.getSegments();
            this.segments = new String[sourceSegments.length + childSegments.length];
            RelativePath.copySegments(this.segments, sourceSegments, sourceSegments.length);
            targetOffsetForChildSegments = sourceSegments.length;
        } else {
            this.segments = new String[childSegments.length];
            targetOffsetForChildSegments = 0;
        }
        RelativePath.copyAndInternSegments(this.segments, targetOffsetForChildSegments, childSegments);
    }

    private static void copySegments(String[] target, String[] source, int length) {
        System.arraycopy(source, 0, target, 0, length);
    }

    private static void copyAndInternSegments(String[] target, int targetOffset, String[] source) {
        for (int i2 = 0; i2 < source.length; ++i2) {
            target[targetOffset + i2] = source[i2];
        }
    }

    public String[] getSegments() {
        return this.segments;
    }

    public boolean isFile() {
        return this.endsWithFile;
    }

    public String getPathString() {
        if (this.segments.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder(256);
        int len = this.segments.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0) {
                path.append('/');
            }
            path.append(this.segments[i2]);
        }
        return path.toString();
    }

    @Override
    public int length() {
        if (this.segments.length == 0) {
            return 0;
        }
        int length = this.segments.length - 1;
        for (String segment : this.segments) {
            length += segment.length();
        }
        return length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        int remaining = index;
        for (int nextSegment = 0; nextSegment < this.segments.length; ++nextSegment) {
            String segment = this.segments[nextSegment];
            int length = segment.length();
            if (remaining < length) {
                return segment.charAt(remaining);
            }
            if (remaining == length) {
                return '/';
            }
            remaining -= length + 1;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return CharBuffer.wrap(this, start, end);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RelativePath that = (RelativePath)o2;
        if (this.endsWithFile != that.endsWithFile) {
            return false;
        }
        return Arrays.equals(this.segments, that.segments);
    }

    public int hashCode() {
        int result = this.endsWithFile ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    @Override
    public String toString() {
        return this.getPathString();
    }

    @Override
    public int compareTo(RelativePath o2) {
        int len1 = this.segments.length;
        int len2 = o2.segments.length;
        if (len1 != len2) {
            return len1 - len2;
        }
        int lim = Math.min(len1, len2);
        String[] v1 = this.segments;
        String[] v2 = o2.segments;
        for (int k2 = 0; k2 < lim; ++k2) {
            int compareResult;
            String c1 = v1[k2];
            String c2 = v2[k2];
            int n2 = compareResult = c1 == c2 ? 0 : c1.compareTo(c2);
            if (compareResult == 0) continue;
            return compareResult;
        }
        return 0;
    }
}

