/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.CachingRegularFileHasher;
import org.gradle.api.internal.changedetection.state.FingerprintCache;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class ClasspathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final NonZipFingerprintingStrategy nonZipFingerprintingStrategy;
    private final ResourceFilter classpathResourceFilter;
    private final ResourceHasher classpathResourceHasher;
    private final RegularFileHasher zipHasher;
    private final Interner<String> stringInterner;

    private ClasspathFingerprintingStrategy(String identifier, NonZipFingerprintingStrategy nonZipFingerprintingStrategy, ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter, Interner<String> stringInterner, FingerprintCache zipFingerprintCache) {
        super(identifier);
        this.nonZipFingerprintingStrategy = nonZipFingerprintingStrategy;
        this.classpathResourceFilter = classpathResourceFilter;
        this.classpathResourceHasher = classpathResourceHasher;
        this.stringInterner = stringInterner;
        this.zipHasher = new CachingRegularFileHasher(new ZipHasher(classpathResourceHasher, classpathResourceFilter), zipFingerprintCache);
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter classpathResourceFilter, ResourceHasher runtimeClasspathResourceHasher, Interner<String> stringInterner, FingerprintCache zipFingerprintCache) {
        return new ClasspathFingerprintingStrategy("CLASSPATH", NonZipFingerprintingStrategy.USE_FILE_HASH, runtimeClasspathResourceHasher, classpathResourceFilter, stringInterner, zipFingerprintCache);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, Interner<String> stringInterner, FingerprintCache zipFingerprintCache) {
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonZipFingerprintingStrategy.IGNORE, classpathResourceHasher, ResourceFilter.FILTER_NOTHING, stringInterner, zipFingerprintCache);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(Iterable<? extends FileSystemSnapshot> roots) {
        ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder = ImmutableMap.builder();
        HashSet<String> processedEntries = new HashSet<String>();
        for (FileSystemSnapshot fileSystemSnapshot : roots) {
            b fingerprintVisitor = new b(processedEntries, builder);
            fileSystemSnapshot.accept(new a(fingerprintVisitor));
        }
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.KEEP_ORDER;
    }

    private HashCode fingerprintRootFile(RegularFileSnapshot fileSnapshot) {
        if (ZipHasher.isZipFile(fileSnapshot.getName())) {
            return this.zipHasher.hash(fileSnapshot);
        }
        return this.nonZipFingerprintingStrategy.determineNonZipFingerprint(fileSnapshot.getHash());
    }

    private class b {
        private final RelativePathStringTracker b;
        private final HashSet<String> c;
        private final ImmutableMap.Builder<String, FileSystemLocationFingerprint> d;

        public b(HashSet<String> processedEntries, ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder) {
            this.c = processedEntries;
            this.d = builder;
            this.b = new RelativePathStringTracker();
        }

        public boolean a(FileSystemLocationSnapshot directorySnapshot) {
            this.b.enter(directorySnapshot);
            return true;
        }

        public void a(FileSystemLocationSnapshot fileSnapshot, HashCode normalizedContentHash) {
            String absolutePath = fileSnapshot.getAbsolutePath();
            if (this.c.add(absolutePath)) {
                FileSystemLocationFingerprint fingerprint = this.b.isRoot() ? IgnoredPathFileSystemLocationFingerprint.create(fileSnapshot.getType(), normalizedContentHash) : this.b(fileSnapshot, normalizedContentHash);
                this.d.put(absolutePath, fingerprint);
            }
        }

        private FileSystemLocationFingerprint b(FileSystemLocationSnapshot snapshot, HashCode content) {
            this.b.enter(snapshot);
            DefaultFileSystemLocationFingerprint fingerprint = new DefaultFileSystemLocationFingerprint(ClasspathFingerprintingStrategy.this.stringInterner.intern(this.b.getRelativePathString()), FileType.RegularFile, content);
            this.b.leave();
            return fingerprint;
        }

        public void a() {
            this.b.leave();
        }
    }

    private class a
    implements FileSystemSnapshotVisitor {
        private final b b;
        private final RelativePathSegmentsTracker c = new RelativePathSegmentsTracker();
        private final Supplier<String[]> d = () -> Iterables.toArray(this.c.getRelativePath(), String.class);

        public a(b delegate) {
            this.b = delegate;
        }

        @Override
        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.c.enter(directorySnapshot);
            return this.b.a(directorySnapshot);
        }

        @Override
        public void visitFile(FileSystemLocationSnapshot fileSnapshot) {
            HashCode normalizedContent;
            if (fileSnapshot.getType() == FileType.RegularFile && (normalizedContent = this.a((RegularFileSnapshot)fileSnapshot)) != null) {
                this.b.a(fileSnapshot, normalizedContent);
            }
        }

        private HashCode a(RegularFileSnapshot fileSnapshot) {
            return this.c.isRoot() ? ClasspathFingerprintingStrategy.this.fingerprintRootFile(fileSnapshot) : this.b(fileSnapshot);
        }

        private HashCode b(RegularFileSnapshot fileSnapshot) {
            this.c.enter(fileSnapshot);
            boolean shouldBeIgnored = ClasspathFingerprintingStrategy.this.classpathResourceFilter.shouldBeIgnored(this.d);
            this.c.leave();
            if (shouldBeIgnored) {
                return null;
            }
            if (ZipHasher.isZipFile(fileSnapshot.getName())) {
                return ClasspathFingerprintingStrategy.this.zipHasher.hash(fileSnapshot);
            }
            return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(fileSnapshot);
        }

        @Override
        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.c.leave();
            this.b.a();
        }
    }

    public static enum NonZipFingerprintingStrategy {
        IGNORE{

            @Override
            public HashCode determineNonZipFingerprint(HashCode original) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonZipFingerprint(HashCode original) {
                return original;
            }
        };


        public abstract HashCode determineNonZipFingerprint(HashCode var1);
    }
}

