/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileMetadata;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySnapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectorySnapshotter.class);
    private final FileHasher hasher;
    private final Interner<String> stringInterner;
    private final a defaultExcludes;

    public DirectorySnapshotter(FileHasher hasher, Interner<String> stringInterner, String ... defaultExcludes) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.defaultExcludes = new a(defaultExcludes);
    }

    public FileSystemLocationSnapshot snapshot(String absolutePath, SnapshottingFilter.DirectoryWalkerPredicate predicate, AtomicBoolean hasBeenFiltered) {
        try {
            Path rootPath = Paths.get(absolutePath, new String[0]);
            b visitor = new b(predicate, hasBeenFiltered, this.hasher, this.stringInterner, this.defaultExcludes);
            Files.walkFileTree(rootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, visitor);
            return visitor.a();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(String.format("Could not list contents of directory '%s'.", absolutePath), e2);
        }
    }

    private static class b
    implements FileVisitor<Path> {
        private final MerkleDirectorySnapshotBuilder a = MerkleDirectorySnapshotBuilder.sortingRequired();
        private final SnapshottingFilter.DirectoryWalkerPredicate b;
        private final AtomicBoolean c;
        private final FileHasher d;
        private final Interner<String> e;
        private final a f;

        public b(SnapshottingFilter.DirectoryWalkerPredicate predicate, AtomicBoolean hasBeenFiltered, FileHasher hasher, Interner<String> stringInterner, a defaultExcludes) {
            this.b = predicate;
            this.c = hasBeenFiltered;
            this.d = hasher;
            this.e = stringInterner;
            this.f = defaultExcludes;
        }

        public FileVisitResult a(Path dir, BasicFileAttributes attrs) {
            String fileName = this.a(dir);
            String internedName = this.a(fileName);
            if (this.a.isRoot() || this.a(dir, internedName, true, attrs, this.a.getRelativePath())) {
                this.a.preVisitDirectory(this.a(dir.toString()), internedName);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        private String a(Path dir) {
            return Optional.ofNullable(dir.getFileName()).map(Object::toString).orElse("");
        }

        public FileVisitResult b(Path file, BasicFileAttributes attrs) {
            String internedName = this.a(file.getFileName().toString());
            if (this.a(file, internedName, false, attrs, this.a.getRelativePath())) {
                this.a.visitFile(this.a(file, internedName, attrs));
            }
            return FileVisitResult.CONTINUE;
        }

        private FileSystemLocationSnapshot a(Path absoluteFilePath, String internedName, BasicFileAttributes attrs) {
            String internedAbsoluteFilePath = this.a(absoluteFilePath.toString());
            if (attrs.isRegularFile()) {
                try {
                    HashCode hash = this.d.hash(absoluteFilePath.toFile(), attrs.size(), attrs.lastModifiedTime().toMillis());
                    FileMetadata metadata = FileMetadata.from(attrs);
                    return new RegularFileSnapshot(internedAbsoluteFilePath, internedName, hash, metadata);
                }
                catch (UncheckedIOException e2) {
                    LOGGER.info("Could not read file path '{}'.", (Object)absoluteFilePath, (Object)e2);
                }
            }
            return new MissingFileSnapshot(internedAbsoluteFilePath, internedName);
        }

        public FileVisitResult a(Path file, IOException exc) {
            boolean isDirectory;
            String internedName;
            if (this.a(exc) && this.a(file, internedName = this.a(file.getFileName().toString()), isDirectory = Files.isDirectory(file, new LinkOption[0]), null, this.a.getRelativePath())) {
                LOGGER.info("Could not read file path '{}'.", (Object)file);
                String internedAbsolutePath = this.a(file.toString());
                this.a.visitFile(new MissingFileSnapshot(internedAbsolutePath, internedName));
            }
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult b(Path dir, IOException exc) {
            if (this.a(exc)) {
                throw new UncheckedIOException(String.format("Could not read directory path '%s'.", dir), exc);
            }
            this.a.postVisitDirectory();
            return FileVisitResult.CONTINUE;
        }

        private boolean a(IOException e2) {
            return e2 != null && !(e2 instanceof FileSystemLoopException);
        }

        private String a(String string) {
            return this.e.intern(string);
        }

        private boolean a(Path path, String internedName, boolean isDirectory, BasicFileAttributes attrs, Iterable<String> relativePath) {
            if (isDirectory ? this.f.a(internedName) : this.f.b(internedName)) {
                return false;
            }
            if (this.b == null) {
                return true;
            }
            boolean allowed = this.b.test(path, internedName, isDirectory, attrs, relativePath);
            if (!allowed) {
                this.c.set(true);
            }
            return allowed;
        }

        public FileSystemLocationSnapshot a() {
            return this.a.getResult();
        }

        @Override
        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
            return this.b((Path)object, iOException);
        }

        @Override
        public /* synthetic */ FileVisitResult visitFileFailed(Object object, IOException iOException) throws IOException {
            return this.a((Path)object, iOException);
        }

        @Override
        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
            return this.b((Path)object, basicFileAttributes);
        }

        @Override
        public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
            return this.a((Path)object, basicFileAttributes);
        }
    }

    static class org.gradle.internal.snapshot.impl.DirectorySnapshotter$a {
        private final ImmutableSet<String> a;
        private final ImmutableSet<String> b;
        private final Predicate<String> c;

        public org.gradle.internal.snapshot.impl.DirectorySnapshotter$a(String[] defaultExcludes) {
            ArrayList<String> excludeFiles = Lists.newArrayList();
            ArrayList<String> excludeDirs = Lists.newArrayList();
            ArrayList<Predicate<String>> excludeFileSpecs = Lists.newArrayList();
            for (String defaultExclude : defaultExcludes) {
                if (defaultExclude.startsWith("**/")) {
                    defaultExclude = defaultExclude.substring(3);
                }
                int length = defaultExclude.length();
                if (defaultExclude.endsWith("/**")) {
                    excludeDirs.add(defaultExclude.substring(0, length - 3));
                    continue;
                }
                int firstStar = defaultExclude.indexOf(42);
                if (firstStar == -1) {
                    excludeFiles.add(defaultExclude);
                    continue;
                }
                b start = firstStar == 0 ? it -> true : new b(defaultExclude.substring(0, firstStar));
                a end = firstStar == length - 1 ? it -> true : new a(defaultExclude.substring(firstStar + 1, length));
                excludeFileSpecs.add(start.and(end));
            }
            this.a = ImmutableSet.copyOf(excludeFiles);
            this.c = excludeFileSpecs.stream().reduce(it -> false, Predicate::or);
            this.b = ImmutableSet.copyOf(excludeDirs);
        }

        public boolean a(String name) {
            return this.b.contains(name);
        }

        public boolean b(String name) {
            return this.a.contains(name) || this.c.test(name);
        }

        private static class b
        implements Predicate<String> {
            private final String a;

            public b(String start) {
                this.a = start;
            }

            public boolean a(String element) {
                return element.startsWith(this.a);
            }

            @Override
            public /* synthetic */ boolean test(Object object) {
                return this.a((String)object);
            }
        }

        private static class a
        implements Predicate<String> {
            private final String a;

            public a(String end) {
                this.a = end;
            }

            public boolean a(String element) {
                return element.endsWith(this.a);
            }

            @Override
            public /* synthetic */ boolean test(Object object) {
                return this.a((String)object);
            }
        }
    }
}

