/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;

public class GZipBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private final BuildCacheEntryPacker delegate;

    @Inject
    public GZipBuildCacheEntryPacker(BuildCacheEntryPacker delegate) {
        this.delegate = delegate;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, OutputStream output, OriginWriter writeOrigin) throws IOException {
        try (GZIPOutputStream gzipOutput = new GZIPOutputStream(output);){
            BuildCacheEntryPacker.PackResult packResult = this.delegate.pack(entity, fingerprints, gzipOutput, writeOrigin);
            return packResult;
        }
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, InputStream input, OriginReader readOrigin) throws IOException {
        try (GZIPInputStream gzipInput = new GZIPInputStream(input);){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.delegate.unpack(entity, gzipInput, readOrigin);
            return unpackResult;
        }
    }
}

