/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.ThreadLocalBufferManager;
import java.lang.ref.SoftReference;

public class BufferRecyclers {
    private static final ThreadLocalBufferManager _bufferRecyclerTracker = "true".equals(System.getProperty("com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecyclers.trackReusableBuffers")) ? ThreadLocalBufferManager.instance() : null;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _encoderRef = new ThreadLocal();

    public static BufferRecycler getBufferRecycler() {
        BufferRecycler br;
        SoftReference<BufferRecycler> ref = _recyclerRef.get();
        BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
        if (br == null) {
            br = new BufferRecycler();
            ref = _bufferRecyclerTracker != null ? _bufferRecyclerTracker.wrapAndTrack(br) : new SoftReference<BufferRecycler>(br);
            _recyclerRef.set(ref);
        }
        return br;
    }

    public static JsonStringEncoder getJsonStringEncoder() {
        JsonStringEncoder enc;
        SoftReference<JsonStringEncoder> ref = _encoderRef.get();
        JsonStringEncoder jsonStringEncoder = enc = ref == null ? null : ref.get();
        if (enc == null) {
            enc = new JsonStringEncoder();
            _encoderRef.set(new SoftReference<JsonStringEncoder>(enc));
        }
        return enc;
    }

    public static byte[] encodeAsUTF8(String text) {
        return BufferRecyclers.getJsonStringEncoder().encodeAsUTF8(text);
    }

    public static char[] quoteAsJsonText(String rawText) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsString(rawText);
    }

    public static byte[] quoteAsJsonUTF8(String rawText) {
        return BufferRecyclers.getJsonStringEncoder().quoteAsUTF8(rawText);
    }
}

