/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth;

import com.gradle.maven.extension.internal.dep.org.apache.http.Consts;
import com.gradle.maven.extension.internal.dep.org.apache.http.HeaderElement;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.MalformedChallengeException;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.AuthSchemeBase;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.BasicHeaderValueParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class RFC2617Scheme
extends AuthSchemeBase
implements Serializable {
    private final Map<String, String> params = new HashMap<String, String>();
    private transient Charset credentialsCharset;

    public RFC2617Scheme(Charset credentialsCharset) {
        this.credentialsCharset = credentialsCharset != null ? credentialsCharset : Consts.ASCII;
    }

    public Charset getCredentialsCharset() {
        return this.credentialsCharset != null ? this.credentialsCharset : Consts.ASCII;
    }

    String getCredentialsCharset(HttpRequest request) {
        String charset = (String)request.getParams().getParameter("http.auth.credential-charset");
        if (charset == null) {
            charset = this.getCredentialsCharset().name();
        }
        return charset;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        BasicHeaderValueParser parser = BasicHeaderValueParser.INSTANCE;
        ParserCursor cursor = new ParserCursor(pos, buffer.length());
        HeaderElement[] elements = parser.parseElements(buffer, cursor);
        this.params.clear();
        for (HeaderElement element : elements) {
            this.params.put(element.getName().toLowerCase(Locale.ROOT), element.getValue());
        }
    }

    protected Map<String, String> getParameters() {
        return this.params;
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        return this.params.get(name.toLowerCase(Locale.ROOT));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }
}

