/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import org.gradle.api.internal.changedetection.state.FingerprintCache;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class CachingResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final HashCode delegateHash;
    private final FingerprintCache hashes;

    public CachingResourceHasher(ResourceHasher delegate, FingerprintCache hashes) {
        this.delegate = delegate;
        Hasher hasher = Hashing.newHasher();
        delegate.appendConfigurationToHasher(hasher);
        this.delegateHash = hasher.hash();
        this.hashes = hashes;
    }

    @Override
    public HashCode hash(ZipEntry zipEntry) throws IOException {
        return this.delegate.hash(zipEntry);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
    }

    @Override
    public HashCode hash(RegularFileSnapshot snapshot) {
        Hasher hasher = Hashing.newHasher();
        hasher.putHash(this.delegateHash);
        hasher.putHash(snapshot.getHash());
        HashCode hash = hasher.hash();
        return this.hashes.computeIfAbsent(snapshot.getAbsolutePath(), hash, hashCode -> this.delegate.hash(snapshot));
    }
}

