/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.api.internal.changedetection.state.ZipInput;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHasher
implements ConfigurableNormalizer,
RegularFileHasher {
    private static final Set<String> KNOWN_ZIP_EXTENSIONS = ImmutableSet.of("zip", "jar", "war", "ear", "apk");
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipHasher.class);
    private final ResourceHasher resourceHasher;
    private final ResourceFilter resourceFilter;

    public static boolean isZipFile(String name) {
        return KNOWN_ZIP_EXTENSIONS.contains(FilenameUtils.getExtension(name).toLowerCase(Locale.ROOT));
    }

    public ZipHasher(ResourceHasher resourceHasher, ResourceFilter resourceFilter) {
        this.resourceHasher = resourceHasher;
        this.resourceFilter = resourceFilter;
    }

    @Override
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return this.hashZipContents(fileSnapshot);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        this.resourceHasher.appendConfigurationToHasher(hasher);
        this.resourceFilter.appendConfigurationToHasher(hasher);
    }

    private HashCode hashZipContents(RegularFileSnapshot zipFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> fingerprints = this.fingerprintZipEntries(zipFileSnapshot.getAbsolutePath());
            if (fingerprints.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            FingerprintHashingStrategy.SORT.appendToHasher(hasher, fingerprints);
            return hasher.hash();
        }
        catch (Exception e2) {
            return this.hashMalformedZip(zipFileSnapshot, e2);
        }
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String zipFile) throws IOException {
        try (ZipInput input = ZipInput.create(new File(zipFile));){
            List<FileSystemLocationFingerprint> list = this.fingerprintZipEntries(input);
            return list;
        }
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(ZipInput input) throws IOException {
        ZipEntry zipEntry;
        ArrayList<FileSystemLocationFingerprint> fingerprints = Lists.newArrayList();
        RelativePathFactory relativePathFactory = new RelativePathFactory();
        while ((zipEntry = input.getNextEntry()) != null) {
            relativePathFactory.setZipEntry(zipEntry);
            if (zipEntry.isDirectory() || this.resourceFilter.shouldBeIgnored(relativePathFactory)) continue;
            if (ZipHasher.isZipFile(zipEntry.getName())) {
                fingerprints.addAll(this.fingerprintZipEntries(ZipInput.create(zipEntry.getInputStream())));
                continue;
            }
            HashCode hash = this.resourceHasher.hash(zipEntry);
            if (hash == null) continue;
            fingerprints.add(new DefaultFileSystemLocationFingerprint(zipEntry.getName(), FileType.RegularFile, hash));
        }
        return fingerprints;
    }

    private HashCode hashMalformedZip(RegularFileSnapshot zipFileSnapshot, Exception e2) {
        LOGGER.debug("Malformed zip '{}'. Falling back to full content hash instead of entry hashing.", (Object)zipFileSnapshot.getName(), (Object)e2);
        return zipFileSnapshot.getHash();
    }

    private static class RelativePathFactory
    implements Supplier<String[]> {
        private ZipEntry zipEntry;

        private RelativePathFactory() {
        }

        @Override
        public String[] get() {
            return FilePathUtil.getPathSegments(this.zipEntry.getName());
        }

        public void setZipEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }
    }
}

