/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import com.gradle.maven.extension.internal.dep.com.google.common.base.CharMatcher;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Splitter;
import java.util.List;
import org.gradle.api.internal.file.pattern.AnythingMatcher;
import org.gradle.api.internal.file.pattern.EndOfPathMatcher;
import org.gradle.api.internal.file.pattern.FixedStepPathMatcher;
import org.gradle.api.internal.file.pattern.GreedyPathMatcher;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternStepFactory;

public class PatternMatcherFactory {
    private static final EndOfPathMatcher END_OF_PATH_MATCHER = new EndOfPathMatcher();
    private static final Splitter PATH_SPLITTER = Splitter.on(CharMatcher.anyOf("\\/")).omitEmptyStrings();

    public static PatternMatcher getPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String pattern) {
        PathMatcher pathMatcher = PatternMatcherFactory.compile(caseSensitive, pattern);
        return new DefaultPatternMatcher(partialMatchDirs, pathMatcher);
    }

    public static PathMatcher compile(boolean caseSensitive, String pattern) {
        if (pattern.length() == 0) {
            return END_OF_PATH_MATCHER;
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            pattern = pattern + "**";
        }
        List<String> parts = PATH_SPLITTER.splitToList(pattern);
        return PatternMatcherFactory.compile(parts, 0, caseSensitive);
    }

    private static PathMatcher compile(List<String> parts, int startIndex, boolean caseSensitive) {
        int pos;
        if (startIndex >= parts.size()) {
            return END_OF_PATH_MATCHER;
        }
        for (pos = startIndex; pos < parts.size() && parts.get(pos).equals("**"); ++pos) {
        }
        if (pos > startIndex) {
            if (pos == parts.size()) {
                return new AnythingMatcher();
            }
            return new GreedyPathMatcher(PatternMatcherFactory.compile(parts, pos, caseSensitive));
        }
        return new FixedStepPathMatcher(PatternStepFactory.getStep(parts.get(pos), caseSensitive), PatternMatcherFactory.compile(parts, pos + 1, caseSensitive));
    }

    static class DefaultPatternMatcher
    extends PatternMatcher {
        private final boolean partialMatchDirs;
        private final PathMatcher pathMatcher;

        public DefaultPatternMatcher(boolean partialMatchDirs, PathMatcher pathMatcher) {
            this.partialMatchDirs = partialMatchDirs;
            this.pathMatcher = pathMatcher;
        }

        @Override
        public boolean test(String[] segments, boolean file) {
            if (file || !this.partialMatchDirs) {
                return this.pathMatcher.matches(segments, 0);
            }
            return this.pathMatcher.isPrefix(segments, 0);
        }
    }
}

