/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalBuildCacheServiceHandle
implements LocalBuildCacheServiceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalBuildCacheServiceHandle.class);
    private final LocalBuildCacheService service;
    private final boolean pushEnabled;

    public DefaultLocalBuildCacheServiceHandle(LocalBuildCacheService service, boolean pushEnabled) {
        this.service = service;
        this.pushEnabled = pushEnabled;
    }

    @Override
    public boolean canLoad() {
        return true;
    }

    @Override
    public void load(BuildCacheKey key, Consumer<? super File> reader) {
        this.service.loadLocally(key, reader);
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled;
    }

    @Override
    public void store(BuildCacheKey key, File file) {
        this.service.storeLocally(key, file);
    }

    @Override
    public void close() {
        this.service.close();
    }
}

