/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public class FileMetadata {
    private final long size;
    private final long lastModified;

    public static FileMetadata from(BasicFileAttributes attributes) {
        return new FileMetadata(attributes.size(), attributes.lastModifiedTime().toMillis());
    }

    public FileMetadata(long size, long lastModified) {
        this.size = size;
        this.lastModified = lastModified;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FileMetadata that = (FileMetadata)o2;
        return this.size == that.size && this.lastModified == that.lastModified;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.lastModified);
    }
}

