/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.scan.extension.test.event.internal;

import com.gradle.maven.scan.extension.test.event.TestFinishedEvent;
import com.gradle.maven.scan.extension.test.event.internal.TestDescriptor;
import com.gradle.maven.scan.extension.test.event.internal.TestResult;
import com.gradle.maven.scan.extension.test.event.internal.TestState;
import java.util.ArrayList;
import java.util.List;

public final class DefaultTestState
implements TestState {
    public final TestDescriptor test;
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final List<Throwable> assumptionFailures = new ArrayList<Throwable>();
    private TestResult.ResultType resultType;

    public DefaultTestState(TestDescriptor test) {
        this.test = test;
    }

    public void completed(TestFinishedEvent event) {
        this.resultType = this.isFailed() ? TestResult.ResultType.FAILURE : (this.isAssumptionFailed() ? TestResult.ResultType.ABORTED : (event.testResult.getResultType() != null ? event.testResult.getResultType() : TestResult.ResultType.SUCCESS));
    }

    @Override
    public Throwable getFailure() {
        if (this.failures.size() == 1) {
            return this.failures.get(0);
        }
        if (this.assumptionFailures.size() == 1) {
            return this.assumptionFailures.get(0);
        }
        return null;
    }

    @Override
    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public void addFailure(Throwable failure) {
        if (!this.failures.isEmpty()) {
            throw new IllegalStateException("Trying to add a failure, but already contains one.");
        }
        if (!this.assumptionFailures.isEmpty()) {
            throw new IllegalStateException("Trying to add a failure, but already contains a failed assumption.");
        }
        this.failures.add(failure);
    }

    public void addAssumptionFailure(Throwable failure) {
        if (!this.assumptionFailures.isEmpty()) {
            throw new IllegalStateException("Trying to add an assumption failure, but already contains one.");
        }
        if (!this.failures.isEmpty()) {
            throw new IllegalStateException("Trying to add an assumption failure, but already contains a failure.");
        }
        this.assumptionFailures.add(failure);
    }

    private boolean isFailed() {
        return !this.failures.isEmpty();
    }

    private boolean isAssumptionFailed() {
        return !this.assumptionFailures.isEmpty();
    }
}

