/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import org.gradle.internal.file.TreeType;

public class PackerDirectoryUtil {
    public static void ensureDirectoryForTree(TreeType type, File root) throws IOException {
        switch (type) {
            case DIRECTORY: {
                PackerDirectoryUtil.makeDirectory(root);
                break;
            }
            case FILE: {
                PackerDirectoryUtil.makeDirectory(root.getParentFile());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public static boolean makeDirectory(File target) throws IOException {
        if (target.isDirectory()) {
            return false;
        }
        if (target.isFile()) {
            FileUtils.forceDelete(target);
        }
        FileUtils.forceMkdir(target);
        return true;
    }
}

