/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class TextBuffer {
    static final char[] NO_CHARS = new char[0];
    private final BufferRecycler _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private ArrayList<char[]> _segments;
    private boolean _hasSegments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public TextBuffer(BufferRecycler bufferRecycler) {
        this._allocator = bufferRecycler;
    }

    protected TextBuffer(BufferRecycler bufferRecycler, char[] cArray) {
        this(bufferRecycler);
        this._currentSegment = cArray;
        this._currentSize = cArray.length;
        this._inputStart = -1;
    }

    public static TextBuffer fromInitial(char[] cArray) {
        return new TextBuffer(null, cArray);
    }

    public void releaseBuffers() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        if (this._allocator != null && this._currentSegment != null) {
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(2, cArray);
        }
    }

    public void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithShared(char[] cArray, int n2, int n3) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n2;
        this._inputLen = n3;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithCopy(char[] cArray, int n2, int n3) throws IOException {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        this._segmentSize = 0;
        this._currentSize = 0;
        this.append(cArray, n2, n3);
    }

    public void resetWithString(String string) throws IOException {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this.validateStringLength(string.length());
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    private char[] buf(int n2) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(2, n2);
        }
        return new char[Math.max(n2, 500)];
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        this._segmentSize = 0;
        this._currentSize = 0;
    }

    public int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public int getTextOffset() {
        return this._inputStart >= 0 ? this._inputStart : 0;
    }

    public boolean hasTextAsCharacters() {
        if (this._inputStart >= 0 || this._resultArray != null) {
            return true;
        }
        return this._resultString == null;
    }

    public char[] getTextBuffer() throws IOException {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            this._resultArray = this._resultString.toCharArray();
            return this._resultArray;
        }
        if (!this._hasSegments) {
            return this._currentSegment == null ? NO_CHARS : this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() throws IOException {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else if (this._inputStart >= 0) {
                if (this._inputLen < 1) {
                    this._resultString = "";
                    return "";
                }
                this.validateStringLength(this._inputLen);
                this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            } else {
                int n2 = this._segmentSize;
                int n3 = this._currentSize;
                if (n2 == 0) {
                    if (n3 == 0) {
                        this._resultString = "";
                    } else {
                        this.validateStringLength(n3);
                        this._resultString = new String(this._currentSegment, 0, n3);
                    }
                } else {
                    int n4 = n2 + n3;
                    if (n4 < 0) {
                        this._reportBufferOverflow(n2, n3);
                    }
                    this.validateStringLength(n4);
                    StringBuilder stringBuilder = new StringBuilder(n4);
                    if (this._segments != null) {
                        int n5 = this._segments.size();
                        for (int i2 = 0; i2 < n5; ++i2) {
                            char[] cArray = this._segments.get(i2);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this._currentSegment, 0, this._currentSize);
                    this._resultString = stringBuilder.toString();
                }
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() throws IOException {
        char[] cArray = this._resultArray;
        if (cArray == null) {
            this._resultArray = cArray = this.resultArray();
        }
        return cArray;
    }

    public int contentsAsInt(boolean bl2) {
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            if (bl2) {
                return -NumberInput.parseInt(this._inputBuffer, this._inputStart + 1, this._inputLen - 1);
            }
            return NumberInput.parseInt(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (bl2) {
            return -NumberInput.parseInt(this._currentSegment, 1, this._currentSize - 1);
        }
        return NumberInput.parseInt(this._currentSegment, 0, this._currentSize);
    }

    public long contentsAsLong(boolean bl2) {
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            if (bl2) {
                return -NumberInput.parseLong(this._inputBuffer, this._inputStart + 1, this._inputLen - 1);
            }
            return NumberInput.parseLong(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (bl2) {
            return -NumberInput.parseLong(this._currentSegment, 1, this._currentSize - 1);
        }
        return NumberInput.parseLong(this._currentSegment, 0, this._currentSize);
    }

    public void append(char c2) throws IOException {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.validateAppend(1);
            this.expand();
            cArray = this._currentSegment;
        }
        cArray[this._currentSize++] = c2;
    }

    public void append(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n5 = cArray2.length - this._currentSize;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n3);
            this._currentSize += n3;
            return;
        }
        this.validateAppend(n3);
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n5);
            n2 += n5;
            n3 -= n5;
        }
        do {
            this.expand();
            n4 = Math.min(this._currentSegment.length, n3);
            System.arraycopy(cArray, n2, this._currentSegment, 0, n4);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public void append(String string, int n2, int n3) throws IOException {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n5 = cArray.length - this._currentSize;
        if (n5 >= n3) {
            string.getChars(n2, n2 + n3, cArray, this._currentSize);
            this._currentSize += n3;
            return;
        }
        this.validateAppend(n3);
        if (n5 > 0) {
            string.getChars(n2, n2 + n5, cArray, this._currentSize);
            n3 -= n5;
            n2 += n5;
        }
        do {
            this.expand();
            n4 = Math.min(this._currentSegment.length, n3);
            string.getChars(n2, n2 + n4, this._currentSegment, 0);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private void validateAppend(int n2) throws IOException {
        int n3 = this._segmentSize + this._currentSize + n2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        this.validateStringLength(n3);
    }

    public char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (cArray == null) {
                this._currentSegment = this.buf(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand();
            }
        }
        return this._currentSegment;
    }

    public char[] emptyAndGetCurrentSegment() {
        char[] cArray;
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        if ((cArray = this._currentSegment) == null) {
            this._currentSegment = cArray = this.buf(0);
        }
        return cArray;
    }

    public int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public String setCurrentAndReturn(int n2) throws IOException {
        String string;
        this._currentSize = n2;
        if (this._segmentSize > 0) {
            return this.contentsAsString();
        }
        int n3 = this._currentSize;
        this.validateStringLength(n3);
        this._resultString = string = n3 == 0 ? "" : new String(this._currentSegment, 0, n3);
        return string;
    }

    public char[] finishCurrentSegment() throws IOException {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n2 = this._currentSegment.length;
        this._segmentSize += n2;
        if (this._segmentSize < 0) {
            this._reportBufferOverflow(this._segmentSize - n2, n2);
        }
        this._currentSize = 0;
        this.validateStringLength(this._segmentSize);
        int n3 = n2 + (n2 >> 1);
        if (n3 < 500) {
            n3 = 500;
        } else if (n3 > 65536) {
            n3 = 65536;
        }
        char[] cArray = this.carr(n3);
        this._currentSegment = cArray;
        return cArray;
    }

    public char[] expandCurrentSegment() {
        char[] cArray = this._currentSegment;
        int n2 = cArray.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 > 65536) {
            n3 = n2 + (n2 >> 2);
        }
        this._currentSegment = Arrays.copyOf(cArray, n3);
        return this._currentSegment;
    }

    public String toString() {
        try {
            return this.contentsAsString();
        }
        catch (IOException iOException) {
            return "TextBuffer: Exception when reading contents";
        }
    }

    private void unshare(int n2) {
        int n3 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n4 = this._inputStart;
        this._inputStart = -1;
        int n5 = n3 + n2;
        if (this._currentSegment == null || n5 > this._currentSegment.length) {
            this._currentSegment = this.buf(n5);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this._currentSegment, 0, n3);
        }
        this._segmentSize = 0;
        this._currentSize = n3;
    }

    private void expand() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        if (this._segmentSize < 0) {
            this._reportBufferOverflow(this._segmentSize - cArray.length, cArray.length);
        }
        this._currentSize = 0;
        int n2 = cArray.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 < 500) {
            n3 = 500;
        } else if (n3 > 65536) {
            n3 = 65536;
        }
        this._currentSegment = this.carr(n3);
    }

    private char[] resultArray() throws IOException {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            int n2 = this._inputLen;
            if (n2 < 1) {
                return NO_CHARS;
            }
            this.validateStringLength(n2);
            int n3 = this._inputStart;
            if (n3 == 0) {
                return Arrays.copyOf(this._inputBuffer, n2);
            }
            return Arrays.copyOfRange(this._inputBuffer, n3, n3 + n2);
        }
        int n4 = this.size();
        if (n4 < 1) {
            if (n4 < 0) {
                this._reportBufferOverflow(this._segmentSize, this._currentSize);
            }
            return NO_CHARS;
        }
        this.validateStringLength(n4);
        int n5 = 0;
        char[] cArray = this.carr(n4);
        if (this._segments != null) {
            int n6 = this._segments.size();
            for (int i2 = 0; i2 < n6; ++i2) {
                char[] cArray2 = this._segments.get(i2);
                int n7 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n5, n7);
                n5 += n7;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n5, this._currentSize);
        return cArray;
    }

    private char[] carr(int n2) {
        return new char[n2];
    }

    protected void _reportBufferOverflow(int n2, int n3) {
        long l2 = (long)n2 + (long)n3;
        throw new IllegalStateException("TextBuffer overrun: size reached (" + l2 + ") exceeds maximum of " + Integer.MAX_VALUE);
    }

    protected void validateStringLength(int n2) throws IOException {
    }
}

