/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jdk14;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.NativeImageUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class JDK14Util {
    public static String[] getRecordFieldNames(Class<?> clazz) {
        return RecordAccessor.instance().getRecordFieldNames(clazz);
    }

    public static AnnotatedConstructor findRecordConstructor(AnnotatedClass annotatedClass, AnnotationIntrospector annotationIntrospector, MapperConfig<?> mapperConfig, List<String> list) {
        return new CreatorLocator(annotatedClass, annotationIntrospector, mapperConfig).locate(list);
    }

    static class CreatorLocator {
        protected final AnnotatedClass _recordClass;
        protected final MapperConfig<?> _config;
        protected final AnnotationIntrospector _intr;
        protected final List<AnnotatedConstructor> _constructors;
        protected final AnnotatedConstructor _primaryConstructor;
        protected final RawTypeName[] _recordFields;

        CreatorLocator(AnnotatedClass annotatedClass, AnnotationIntrospector annotationIntrospector, MapperConfig<?> mapperConfig) {
            this._recordClass = annotatedClass;
            this._intr = annotationIntrospector;
            this._config = mapperConfig;
            this._recordFields = RecordAccessor.instance().getRecordFields(annotatedClass.getRawType());
            if (this._recordFields == null) {
                this._constructors = annotatedClass.getConstructors();
                this._primaryConstructor = null;
            } else {
                int n2 = this._recordFields.length;
                AnnotatedConstructor annotatedConstructor = null;
                if (n2 == 0) {
                    annotatedConstructor = annotatedClass.getDefaultConstructor();
                    this._constructors = Collections.singletonList(annotatedConstructor);
                } else {
                    this._constructors = annotatedClass.getConstructors();
                    block0: for (AnnotatedConstructor annotatedConstructor2 : this._constructors) {
                        if (annotatedConstructor2.getParameterCount() != n2) continue;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            if (!annotatedConstructor2.getRawParameterType(i2).equals(this._recordFields[i2].rawType)) continue block0;
                        }
                        annotatedConstructor = annotatedConstructor2;
                        break;
                    }
                }
                if (annotatedConstructor == null) {
                    throw new IllegalArgumentException("Failed to find the canonical Record constructor of type " + ClassUtil.getTypeDescription(this._recordClass.getType()));
                }
                this._primaryConstructor = annotatedConstructor;
            }
        }

        public AnnotatedConstructor locate(List<String> list) {
            for (AnnotatedConstructor annotatedConstructor : this._constructors) {
                JsonCreator.Mode mode = this._intr.findCreatorAnnotation(this._config, annotatedConstructor);
                if (null == mode || JsonCreator.Mode.DISABLED == mode) continue;
                if (JsonCreator.Mode.DELEGATING == mode) {
                    return null;
                }
                if (annotatedConstructor == this._primaryConstructor) continue;
                return null;
            }
            if (this._recordFields == null) {
                return null;
            }
            for (RawTypeName rawTypeName : this._recordFields) {
                list.add(rawTypeName.name);
            }
            return this._primaryConstructor;
        }
    }

    static class RawTypeName {
        public final Class<?> rawType;
        public final String name;

        public RawTypeName(Class<?> clazz, String string) {
            this.rawType = clazz;
            this.name = string;
        }
    }

    static class RecordAccessor {
        private final Method RECORD_GET_RECORD_COMPONENTS;
        private final Method RECORD_COMPONENT_GET_NAME;
        private final Method RECORD_COMPONENT_GET_TYPE;
        private static final RecordAccessor INSTANCE;
        private static final RuntimeException PROBLEM;

        private RecordAccessor() throws RuntimeException {
            try {
                this.RECORD_GET_RECORD_COMPONENTS = Class.class.getMethod("getRecordComponents", new Class[0]);
                Class<?> clazz = Class.forName("java.lang.reflect.RecordComponent");
                this.RECORD_COMPONENT_GET_NAME = clazz.getMethod("getName", new Class[0]);
                this.RECORD_COMPONENT_GET_TYPE = clazz.getMethod("getType", new Class[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Failed to access Methods needed to support `java.lang.Record`: (%s) %s", exception.getClass().getName(), exception.getMessage()), exception);
            }
        }

        public static RecordAccessor instance() {
            if (PROBLEM != null) {
                throw PROBLEM;
            }
            return INSTANCE;
        }

        public String[] getRecordFieldNames(Class<?> clazz) throws IllegalArgumentException {
            Object[] objectArray = this.recordComponents(clazz);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    stringArray[i2] = (String)this.RECORD_COMPONENT_GET_NAME.invoke(objectArray[i2], new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i2, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
            }
            return stringArray;
        }

        public RawTypeName[] getRecordFields(Class<?> clazz) throws IllegalArgumentException {
            Object[] objectArray = this.recordComponents(clazz);
            if (objectArray == null) {
                return null;
            }
            RawTypeName[] rawTypeNameArray = new RawTypeName[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Class clazz2;
                String string;
                try {
                    string = (String)this.RECORD_COMPONENT_GET_NAME.invoke(objectArray[i2], new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i2, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
                try {
                    clazz2 = (Class)this.RECORD_COMPONENT_GET_TYPE.invoke(objectArray[i2], new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access type of field #%d (of %d) of Record type %s", i2, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
                rawTypeNameArray[i2] = new RawTypeName(clazz2, string);
            }
            return rawTypeNameArray;
        }

        protected Object[] recordComponents(Class<?> clazz) throws IllegalArgumentException {
            try {
                return (Object[])this.RECORD_GET_RECORD_COMPONENTS.invoke(clazz, new Object[0]);
            }
            catch (Exception exception) {
                if (NativeImageUtil.isUnsupportedFeatureError(exception)) {
                    return null;
                }
                throw new IllegalArgumentException("Failed to access RecordComponents of type " + ClassUtil.nameOf(clazz));
            }
        }

        static {
            RuntimeException runtimeException = null;
            RecordAccessor recordAccessor = null;
            try {
                recordAccessor = new RecordAccessor();
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
            INSTANCE = recordAccessor;
            PROBLEM = runtimeException;
        }
    }
}

