/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Hashing;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapEntry;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapEntrySet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.IndexedImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.JdkBackedImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entryArray) {
        return RegularImmutableMap.fromEntryArray(entryArray.length, entryArray, true);
    }

    static <K, V> ImmutableMap<K, V> fromEntryArray(int n2, Map.Entry<K, V>[] entryArray, boolean bl2) {
        Preconditions.checkPositionIndex(n2, entryArray.length);
        if (n2 == 0) {
            ImmutableMap<Object, Object> immutableMap = EMPTY;
            return immutableMap;
        }
        try {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(n2, entryArray, bl2);
        }
        catch (BucketOverflowException bucketOverflowException) {
            return JdkBackedImmutableMap.create(n2, entryArray, bl2);
        }
    }

    private static <K, V> ImmutableMap<K, V> fromEntryArrayCheckingBucketOverflow(int n2, Map.Entry<K, V>[] entryArray, boolean bl2) throws BucketOverflowException {
        int n3;
        Map.Entry<K, V>[] entryArray2 = n2 == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n2);
        int n4 = Hashing.closedTableSize(n2, 1.2);
        ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n4);
        int n5 = n4 - 1;
        IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean> identityHashMap = null;
        int n6 = 0;
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[n3]);
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k2, v2);
            int n7 = Hashing.smear(k2.hashCode()) & n5;
            ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n7];
            ImmutableMapEntry immutableMapEntry2 = RegularImmutableMap.checkNoConflictInKeyBucket(k2, v2, immutableMapEntry, bl2);
            if (immutableMapEntry2 == null) {
                immutableMapEntry2 = immutableMapEntry == null ? RegularImmutableMap.makeImmutable(entry, k2, v2) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(k2, v2, immutableMapEntry);
                immutableMapEntryArray[n7] = immutableMapEntry2;
            } else {
                if (identityHashMap == null) {
                    identityHashMap = new IdentityHashMap<ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>, Boolean>();
                }
                identityHashMap.put((ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>)immutableMapEntry2, true);
                ++n6;
                if (entryArray2 == entryArray) {
                    Map.Entry<K, V>[] entryArray3 = entryArray2;
                    entryArray2 = (Map.Entry[])entryArray3.clone();
                }
            }
            entryArray2[n3] = immutableMapEntry2;
        }
        if (identityHashMap != null && (n3 = Hashing.closedTableSize((entryArray2 = RegularImmutableMap.removeDuplicates(entryArray2, n2, n2 - n6, identityHashMap)).length, 1.2)) != n4) {
            return RegularImmutableMap.fromEntryArrayCheckingBucketOverflow(entryArray2.length, entryArray2, true);
        }
        return new RegularImmutableMap<K, V>(entryArray2, immutableMapEntryArray, n5);
    }

    static <K, V> Map.Entry<K, V>[] removeDuplicates(Map.Entry<K, V>[] entryArray, int n2, int n3, IdentityHashMap<Map.Entry<K, V>, Boolean> identityHashMap) {
        ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n3);
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Map.Entry<K, V> entry = entryArray[i2];
            Boolean bl2 = identityHashMap.get(entry);
            if (bl2 != null) {
                if (!bl2.booleanValue()) continue;
                identityHashMap.put(entry, false);
            }
            immutableMapEntryArray[n4++] = entry;
        }
        return immutableMapEntryArray;
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K k2, V v2) {
        boolean bl2 = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        return bl2 ? (ImmutableMapEntry)entry : new ImmutableMapEntry<K, V>(k2, v2);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry) {
        return RegularImmutableMap.makeImmutable(entry, entry.getKey(), entry.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entryArray, ImmutableMapEntry<K, V>[] immutableMapEntryArray, int n2) {
        this.entries = entryArray;
        this.table = immutableMapEntryArray;
        this.mask = n2;
    }

    static <K, V> ImmutableMapEntry<K, V> checkNoConflictInKeyBucket(Object object, Object object2, ImmutableMapEntry<K, V> immutableMapEntry, boolean bl2) throws BucketOverflowException {
        int n2 = 0;
        while (immutableMapEntry != null) {
            if (immutableMapEntry.getKey().equals(object)) {
                if (bl2) {
                    RegularImmutableMap.checkNoConflict(false, "key", immutableMapEntry, object + "=" + object2);
                } else {
                    return immutableMapEntry;
                }
            }
            if (++n2 > 8) {
                throw new BucketOverflowException();
            }
            immutableMapEntry = immutableMapEntry.getNextInKeyBucket();
        }
        return null;
    }

    @Override
    public V get(Object object) {
        return RegularImmutableMap.get(object, this.table, this.mask);
    }

    static <V> V get(Object object, ImmutableMapEntry<?, V>[] immutableMapEntryArray, int n2) {
        if (object == null || immutableMapEntryArray == null) {
            return null;
        }
        int n3 = Hashing.smear(object.hashCode()) & n2;
        for (ImmutableMapEntry<?, V> immutableMapEntry = immutableMapEntryArray[n3]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInKeyBucket()) {
            Object k2 = immutableMapEntry.getKey();
            if (!object.equals(k2)) continue;
            return immutableMapEntry.getValue();
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (Map.Entry<K, V> entry : this.entries) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    private static final class Values<K, V>
    extends ImmutableList<V> {
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        public V get(int n2) {
            return this.map.entries[n2].getValue();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private static final class KeySet<K>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, ?> map;

        KeySet(RegularImmutableMap<K, ?> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        K get(int n2) {
            return this.map.entries[n2].getKey();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static class BucketOverflowException
    extends Exception {
        BucketOverflowException() {
        }
    }
}

