/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.extensions;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.IteratingCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.LifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.BatchMode;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.WriteCallback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.Generator;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.Parser;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Queue;

public class ExtensionStack
extends ContainerLifeCycle
implements IncomingFrames,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(ExtensionStack.class);
    private final Queue<FrameEntry> entries = new ArrayDeque<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private final ExtensionFactory factory;
    private List<Extension> extensions;
    private IncomingFrames nextIncoming;
    private OutgoingFrames nextOutgoing;

    public ExtensionStack(ExtensionFactory extensionFactory) {
        this.factory = extensionFactory;
    }

    public void configure(Generator generator) {
        generator.configureFromExtensions(this.extensions);
    }

    public void configure(Parser parser) {
        parser.configureFromExtensions(this.extensions);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.extensions != null && this.extensions.size() > 0) {
            Extension extension;
            ListIterator<Extension> listIterator = this.extensions.listIterator();
            while (listIterator.hasNext()) {
                extension = listIterator.next();
                extension.setNextOutgoingFrames(this.nextOutgoing);
                this.nextOutgoing = extension;
                if (!(extension instanceof LifeCycle)) continue;
                this.addBean(extension, true);
            }
            while (listIterator.hasPrevious()) {
                extension = listIterator.previous();
                extension.setNextIncomingFrames(this.nextIncoming);
                this.nextIncoming = extension;
            }
        }
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x[size=%d,queueSize=%d]", this.getClass().getSimpleName(), this.hashCode(), this.extensions.size(), this.getQueueSize());
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncoming.incomingFrame(frame);
    }

    public void negotiate(List<ExtensionConfig> list) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extension Configs={}", list);
        }
        this.extensions = new ArrayList<Extension>();
        String[] stringArray = new String[3];
        for (ExtensionConfig extensionConfig : list) {
            Extension extension = this.factory.newInstance(extensionConfig);
            if (extension == null) continue;
            if (extension.isRsv1User() && stringArray[0] != null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding extension {}. Extension {} already claimed RSV1", extensionConfig, stringArray[0]);
                continue;
            }
            if (extension.isRsv2User() && stringArray[1] != null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding extension {}. Extension {} already claimed RSV2", extensionConfig, stringArray[1]);
                continue;
            }
            if (extension.isRsv3User() && stringArray[2] != null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Not adding extension {}. Extension {} already claimed RSV3", extensionConfig, stringArray[2]);
                continue;
            }
            this.extensions.add(extension);
            this.addBean(extension);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding Extension: {}", extensionConfig);
            }
            if (extension.isRsv1User()) {
                stringArray[0] = extension.getName();
            }
            if (extension.isRsv2User()) {
                stringArray[1] = extension.getName();
            }
            if (!extension.isRsv3User()) continue;
            stringArray[2] = extension.getName();
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
        FrameEntry frameEntry = new FrameEntry(frame, writeCallback, batchMode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing {}", frameEntry);
        }
        this.offerEntry(frameEntry);
        this.flusher.iterate();
    }

    public void setNextIncoming(IncomingFrames incomingFrames) {
        this.nextIncoming = incomingFrames;
    }

    public void setNextOutgoing(OutgoingFrames outgoingFrames) {
        this.nextOutgoing = outgoingFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEntry(FrameEntry frameEntry) {
        ExtensionStack extensionStack = this;
        synchronized (extensionStack) {
            this.entries.offer(frameEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameEntry pollEntry() {
        ExtensionStack extensionStack = this;
        synchronized (extensionStack) {
            return this.entries.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getQueueSize() {
        ExtensionStack extensionStack = this;
        synchronized (extensionStack) {
            return this.entries.size();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ExtensionStack[");
        stringBuilder.append("queueSize=").append(this.getQueueSize());
        stringBuilder.append(",extensions=");
        if (this.extensions == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append('[');
            boolean bl2 = false;
            for (Extension extension : this.extensions) {
                if (bl2) {
                    stringBuilder.append(',');
                }
                if (extension == null) {
                    stringBuilder.append("<null>");
                } else {
                    stringBuilder.append(extension.getName());
                }
                bl2 = true;
            }
            stringBuilder.append(']');
        }
        stringBuilder.append(",incoming=").append(this.nextIncoming == null ? "<null>" : this.nextIncoming.getClass().getName());
        stringBuilder.append(",outgoing=").append(this.nextOutgoing == null ? "<null>" : this.nextOutgoing.getClass().getName());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            this.current = ExtensionStack.this.pollEntry();
            if (this.current == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entering IDLE", new Object[0]);
                }
                return IteratingCallback.Action.IDLE;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing {}", this.current);
            }
            ExtensionStack.this.nextOutgoing.outgoingFrame(this.current.frame, this, this.current.batchMode);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onCompleteSuccess() {
        }

        @Override
        protected void onCompleteFailure(Throwable throwable) {
        }

        @Override
        public void writeSuccess() {
            this.notifyCallbackSuccess(this.current.callback);
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable throwable) {
            this.notifyCallbackFailure(this.current.callback, throwable);
            this.succeeded();
        }

        private void notifyCallbackSuccess(WriteCallback writeCallback) {
            block3: {
                try {
                    if (writeCallback != null) {
                        writeCallback.writeSuccess();
                    }
                }
                catch (Throwable throwable) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying success of callback " + writeCallback, throwable);
                }
            }
        }

        private void notifyCallbackFailure(WriteCallback writeCallback, Throwable throwable) {
            block3: {
                try {
                    if (writeCallback != null) {
                        writeCallback.writeFailed(throwable);
                    }
                }
                catch (Throwable throwable2) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Exception while notifying failure of callback " + writeCallback, throwable2);
                }
            }
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback writeCallback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = writeCallback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

