/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie;

import com.gradle.maven.extension.internal.dep.org.apache.http.client.utils.DateUtils;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.MalformedCookieException;
import com.gradle.maven.extension.internal.dep.org.apache.http.cookie.SetCookie;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.util.Date;

public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datePatterns;

    public BasicExpiresHandler(String[] stringArray) {
        Args.notNull(stringArray, "Array of date patterns");
        this.datePatterns = (String[])stringArray.clone();
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date date = DateUtils.parseDate(string, this.datePatterns);
        if (date == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        setCookie.setExpiryDate(date);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

