/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.PropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.AstUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.PropertyOrFieldReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.StringLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;

public class Indexer
extends SpelNodeImpl {
    private String cachedReadName;
    private Class<?> cachedReadTargetType;
    private PropertyAccessor cachedReadAccessor;
    private String cachedWriteName;
    private Class<?> cachedWriteTargetType;
    private PropertyAccessor cachedWriteAccessor;
    private IndexedType indexedType;

    public Indexer(int n2, int n3, SpelNodeImpl spelNodeImpl) {
        super(n2, n3, spelNodeImpl);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        return this.getValueRef(expressionState).getValue();
    }

    @Override
    public TypedValue setValueInternal(ExpressionState expressionState, Supplier<TypedValue> supplier) throws EvaluationException {
        TypedValue typedValue = supplier.get();
        this.getValueRef(expressionState).setValue(typedValue.getValue());
        return typedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        TypedValue typedValue;
        Object object;
        Object object2;
        TypedValue typedValue2 = expressionState.getActiveContextObject();
        Object object3 = typedValue2.getValue();
        TypeDescriptor typeDescriptor = typedValue2.getTypeDescriptor();
        if (object3 instanceof Map && this.children[0] instanceof PropertyOrFieldReference) {
            object2 = (PropertyOrFieldReference)this.children[0];
            object = ((PropertyOrFieldReference)object2).getName();
            typedValue = new TypedValue(object);
        } else {
            try {
                expressionState.pushActiveContextObject(expressionState.getRootContextObject());
                typedValue = this.children[0].getValueInternal(expressionState);
                object = typedValue.getValue();
                Assert.state(object != null, "No index");
            }
            finally {
                expressionState.popActiveContextObject();
            }
        }
        if (object3 == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        Assert.state(typeDescriptor != null, "No type descriptor");
        if (object3 instanceof Map) {
            object2 = object;
            if (typeDescriptor.getMapKeyTypeDescriptor() != null) {
                object2 = expressionState.convertValue(object2, typeDescriptor.getMapKeyTypeDescriptor());
            }
            this.indexedType = IndexedType.MAP;
            return new MapIndexingValueRef(expressionState.getTypeConverter(), (Map)object3, object2, typeDescriptor);
        }
        if (object3.getClass().isArray() || object3 instanceof Collection || object3 instanceof String) {
            int n2 = (Integer)expressionState.convertValue(object, TypeDescriptor.valueOf(Integer.class));
            if (object3.getClass().isArray()) {
                this.indexedType = IndexedType.ARRAY;
                return new ArrayIndexingValueRef(expressionState.getTypeConverter(), object3, n2, typeDescriptor);
            }
            if (object3 instanceof Collection) {
                if (object3 instanceof List) {
                    this.indexedType = IndexedType.LIST;
                }
                return new CollectionIndexingValueRef((Collection)object3, n2, typeDescriptor, expressionState.getTypeConverter(), expressionState.getConfiguration().isAutoGrowCollections(), expressionState.getConfiguration().getMaximumAutoGrowSize());
            }
            this.indexedType = IndexedType.STRING;
            return new StringIndexingLValue((String)object3, n2, typeDescriptor);
        }
        object2 = typedValue.getTypeDescriptor();
        if (object2 != null && String.class == ((TypeDescriptor)object2).getType()) {
            this.indexedType = IndexedType.OBJECT;
            return new PropertyIndexingValueRef(object3, (String)object, expressionState.getEvaluationContext(), typeDescriptor);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, typeDescriptor);
    }

    @Override
    public boolean isCompilable() {
        if (this.indexedType == IndexedType.ARRAY) {
            return this.exitTypeDescriptor != null;
        }
        if (this.indexedType == IndexedType.LIST) {
            return this.children[0].isCompilable();
        }
        if (this.indexedType == IndexedType.MAP) {
            return this.children[0] instanceof PropertyOrFieldReference || this.children[0].isCompilable();
        }
        if (this.indexedType == IndexedType.OBJECT) {
            return this.cachedReadAccessor != null && this.cachedReadAccessor instanceof ReflectivePropertyAccessor.OptimalPropertyAccessor && this.getChild(0) instanceof StringLiteral;
        }
        return false;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        String string = codeFlow.lastDescriptor();
        if (string == null) {
            codeFlow.loadTarget(methodVisitor);
        }
        if (this.indexedType == IndexedType.ARRAY) {
            int n2;
            if ("D".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[D");
                n2 = 49;
            } else if ("F".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[F");
                n2 = 48;
            } else if ("J".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[J");
                n2 = 47;
            } else if ("I".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[I");
                n2 = 46;
            } else if ("S".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[S");
                n2 = 53;
            } else if ("B".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[B");
                n2 = 51;
            } else if ("C".equals(this.exitTypeDescriptor)) {
                methodVisitor.visitTypeInsn(192, "[C");
                n2 = 52;
            } else {
                methodVisitor.visitTypeInsn(192, "[" + this.exitTypeDescriptor + (CodeFlow.isPrimitiveArray(this.exitTypeDescriptor) ? "" : ";"));
                n2 = 50;
            }
            SpelNodeImpl spelNodeImpl = this.children[0];
            codeFlow.enterCompilationScope();
            spelNodeImpl.generateCode(methodVisitor, codeFlow);
            codeFlow.exitCompilationScope();
            methodVisitor.visitInsn(n2);
        } else if (this.indexedType == IndexedType.LIST) {
            methodVisitor.visitTypeInsn(192, "java/util/List");
            codeFlow.enterCompilationScope();
            this.children[0].generateCode(methodVisitor, codeFlow);
            codeFlow.exitCompilationScope();
            methodVisitor.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.MAP) {
            methodVisitor.visitTypeInsn(192, "java/util/Map");
            if (this.children[0] instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference propertyOrFieldReference = (PropertyOrFieldReference)this.children[0];
                String string2 = propertyOrFieldReference.getName();
                methodVisitor.visitLdcInsn(string2);
            } else {
                codeFlow.enterCompilationScope();
                this.children[0].generateCode(methodVisitor, codeFlow);
                codeFlow.exitCompilationScope();
            }
            methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.OBJECT) {
            ReflectivePropertyAccessor.OptimalPropertyAccessor optimalPropertyAccessor = (ReflectivePropertyAccessor.OptimalPropertyAccessor)this.cachedReadAccessor;
            Assert.state(optimalPropertyAccessor != null, "No cached read accessor");
            Member member = optimalPropertyAccessor.member;
            boolean bl2 = Modifier.isStatic(member.getModifiers());
            String string3 = member.getDeclaringClass().getName().replace('.', '/');
            if (!bl2) {
                if (string == null) {
                    codeFlow.loadTarget(methodVisitor);
                }
                if (string == null || !string3.equals(string.substring(1))) {
                    methodVisitor.visitTypeInsn(192, string3);
                }
            }
            if (member instanceof Method) {
                methodVisitor.visitMethodInsn(bl2 ? 184 : 182, string3, member.getName(), CodeFlow.createSignatureDescriptor((Method)member), false);
            } else {
                methodVisitor.visitFieldInsn(bl2 ? 178 : 180, string3, member.getName(), CodeFlow.toJvmDescriptor(((Field)member).getType()));
            }
        }
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }

    @Override
    public String toStringAST() {
        StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            stringJoiner.add(this.getChild(i2).toStringAST());
        }
        return stringJoiner.toString();
    }

    private void setArrayElement(TypeConverter typeConverter, Object object, int n2, Object object2, Class<?> clazz) throws EvaluationException {
        if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            this.checkAccess(blArray.length, n2);
            blArray[n2] = this.convertValue(typeConverter, object2, Boolean.class);
        } else if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            this.checkAccess(byArray.length, n2);
            byArray[n2] = this.convertValue(typeConverter, object2, Byte.class);
        } else if (clazz == Character.TYPE) {
            char[] cArray = (char[])object;
            this.checkAccess(cArray.length, n2);
            cArray[n2] = this.convertValue(typeConverter, object2, Character.class).charValue();
        } else if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            this.checkAccess(dArray.length, n2);
            dArray[n2] = this.convertValue(typeConverter, object2, Double.class);
        } else if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            this.checkAccess(fArray.length, n2);
            fArray[n2] = this.convertValue(typeConverter, object2, Float.class).floatValue();
        } else if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            this.checkAccess(nArray.length, n2);
            nArray[n2] = this.convertValue(typeConverter, object2, Integer.class);
        } else if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            this.checkAccess(lArray.length, n2);
            lArray[n2] = this.convertValue(typeConverter, object2, Long.class);
        } else if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            this.checkAccess(sArray.length, n2);
            sArray[n2] = this.convertValue(typeConverter, object2, Short.class);
        } else {
            Object[] objectArray = (Object[])object;
            this.checkAccess(objectArray.length, n2);
            objectArray[n2] = this.convertValue(typeConverter, object2, clazz);
        }
    }

    private Object accessArrayElement(Object object, int n2) throws SpelEvaluationException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            this.checkAccess(blArray.length, n2);
            this.exitTypeDescriptor = "Z";
            return blArray[n2];
        }
        if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            this.checkAccess(byArray.length, n2);
            this.exitTypeDescriptor = "B";
            return byArray[n2];
        }
        if (clazz == Character.TYPE) {
            char[] cArray = (char[])object;
            this.checkAccess(cArray.length, n2);
            this.exitTypeDescriptor = "C";
            return Character.valueOf(cArray[n2]);
        }
        if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            this.checkAccess(dArray.length, n2);
            this.exitTypeDescriptor = "D";
            return dArray[n2];
        }
        if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            this.checkAccess(fArray.length, n2);
            this.exitTypeDescriptor = "F";
            return Float.valueOf(fArray[n2]);
        }
        if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            this.checkAccess(nArray.length, n2);
            this.exitTypeDescriptor = "I";
            return nArray[n2];
        }
        if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            this.checkAccess(lArray.length, n2);
            this.exitTypeDescriptor = "J";
            return lArray[n2];
        }
        if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            this.checkAccess(sArray.length, n2);
            this.exitTypeDescriptor = "S";
            return sArray[n2];
        }
        Object[] objectArray = (Object[])object;
        this.checkAccess(objectArray.length, n2);
        Object object2 = objectArray[n2];
        this.exitTypeDescriptor = CodeFlow.toDescriptor(clazz);
        return object2;
    }

    private void checkAccess(int n2, int n3) throws SpelEvaluationException {
        if (n3 >= n2) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, n2, n3);
        }
    }

    private <T> T convertValue(TypeConverter typeConverter, Object object, Class<T> clazz) {
        Object object2 = typeConverter.convertValue(object, TypeDescriptor.forObject(object), TypeDescriptor.valueOf(clazz));
        if (object2 == null) {
            throw new IllegalStateException("Null conversion result for index [" + object + "]");
        }
        return (T)object2;
    }

    private class StringIndexingLValue
    implements ValueRef {
        private final String target;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        public StringIndexingLValue(String string, int n2, TypeDescriptor typeDescriptor) {
            this.target = string;
            this.index = n2;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            if (this.index >= this.target.length()) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, this.target.length(), this.index);
            }
            return new TypedValue(String.valueOf(this.target.charAt(this.index)));
        }

        @Override
        public void setValue(Object object) {
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.typeDescriptor.toString());
        }
    }

    private class CollectionIndexingValueRef
    implements ValueRef {
        private final Collection collection;
        private final int index;
        private final TypeDescriptor collectionEntryDescriptor;
        private final TypeConverter typeConverter;
        private final boolean growCollection;
        private final int maximumSize;

        public CollectionIndexingValueRef(Collection collection, int n2, TypeDescriptor typeDescriptor, TypeConverter typeConverter, boolean bl2, int n3) {
            this.collection = collection;
            this.index = n2;
            this.collectionEntryDescriptor = typeDescriptor;
            this.typeConverter = typeConverter;
            this.growCollection = bl2;
            this.maximumSize = n3;
        }

        @Override
        public TypedValue getValue() {
            this.growCollectionIfNecessary();
            if (this.collection instanceof List) {
                Object e2 = ((List)this.collection).get(this.index);
                Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
                return new TypedValue(e2, this.collectionEntryDescriptor.elementTypeDescriptor(e2));
            }
            int n2 = 0;
            for (Object e3 : this.collection) {
                if (n2 == this.index) {
                    return new TypedValue(e3, this.collectionEntryDescriptor.elementTypeDescriptor(e3));
                }
                ++n2;
            }
            throw new IllegalStateException("Failed to find indexed element " + this.index + ": " + this.collection);
        }

        @Override
        public void setValue(Object object) {
            List list;
            this.growCollectionIfNecessary();
            if (this.collection instanceof List) {
                list = (List)this.collection;
                if (this.collectionEntryDescriptor.getElementTypeDescriptor() != null) {
                    object = this.typeConverter.convertValue(object, TypeDescriptor.forObject(object), this.collectionEntryDescriptor.getElementTypeDescriptor());
                }
            } else {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.collectionEntryDescriptor.toString());
            }
            list.set(this.index, object);
        }

        private void growCollectionIfNecessary() {
            if (this.index >= this.collection.size()) {
                if (!this.growCollection) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, this.collection.size(), this.index);
                }
                if (this.index >= this.maximumSize) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                }
                if (this.collectionEntryDescriptor.getElementTypeDescriptor() == null) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION_UNKNOWN_ELEMENT_TYPE, new Object[0]);
                }
                TypeDescriptor typeDescriptor = this.collectionEntryDescriptor.getElementTypeDescriptor();
                try {
                    Constructor<?> constructor = this.getDefaultConstructor(typeDescriptor.getType());
                    for (int i2 = this.index - this.collection.size(); i2 >= 0; --i2) {
                        this.collection.add(constructor != null ? (Object)constructor.newInstance(new Object[0]) : null);
                    }
                }
                catch (Throwable throwable) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), throwable, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                }
            }
        }

        private Constructor<?> getDefaultConstructor(Class<?> clazz) {
            try {
                return ReflectionUtils.accessibleConstructor(clazz, new Class[0]);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    private class PropertyIndexingValueRef
    implements ValueRef {
        private final Object targetObject;
        private final String name;
        private final EvaluationContext evaluationContext;
        private final TypeDescriptor targetObjectTypeDescriptor;

        public PropertyIndexingValueRef(Object object, String string, EvaluationContext evaluationContext, TypeDescriptor typeDescriptor) {
            this.targetObject = object;
            this.name = string;
            this.evaluationContext = evaluationContext;
            this.targetObjectTypeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Class<?> clazz = Indexer.this.getObjectClass(this.targetObject);
            try {
                if (Indexer.this.cachedReadName != null && Indexer.this.cachedReadName.equals(this.name) && Indexer.this.cachedReadTargetType != null && Indexer.this.cachedReadTargetType.equals(clazz)) {
                    PropertyAccessor propertyAccessor = Indexer.this.cachedReadAccessor;
                    Assert.state(propertyAccessor != null, "No cached read accessor");
                    return propertyAccessor.read(this.evaluationContext, this.targetObject, this.name);
                }
                List<PropertyAccessor> list = AstUtils.getPropertyAccessorsToTry(clazz, this.evaluationContext.getPropertyAccessors());
                for (PropertyAccessor propertyAccessor : list) {
                    if (!propertyAccessor.canRead(this.evaluationContext, this.targetObject, this.name)) continue;
                    if (propertyAccessor instanceof ReflectivePropertyAccessor) {
                        propertyAccessor = ((ReflectivePropertyAccessor)propertyAccessor).createOptimalAccessor(this.evaluationContext, this.targetObject, this.name);
                    }
                    Indexer.this.cachedReadAccessor = propertyAccessor;
                    Indexer.this.cachedReadName = this.name;
                    Indexer.this.cachedReadTargetType = clazz;
                    if (propertyAccessor instanceof ReflectivePropertyAccessor.OptimalPropertyAccessor) {
                        ReflectivePropertyAccessor.OptimalPropertyAccessor optimalPropertyAccessor = (ReflectivePropertyAccessor.OptimalPropertyAccessor)propertyAccessor;
                        Member member = optimalPropertyAccessor.member;
                        Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(member instanceof Method ? ((Method)member).getReturnType() : ((Field)member).getType());
                    }
                    return propertyAccessor.read(this.evaluationContext, this.targetObject, this.name);
                }
            }
            catch (AccessException accessException) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)accessException, SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
        }

        @Override
        public void setValue(Object object) {
            Class<?> clazz = Indexer.this.getObjectClass(this.targetObject);
            try {
                if (Indexer.this.cachedWriteName != null && Indexer.this.cachedWriteName.equals(this.name) && Indexer.this.cachedWriteTargetType != null && Indexer.this.cachedWriteTargetType.equals(clazz)) {
                    PropertyAccessor propertyAccessor = Indexer.this.cachedWriteAccessor;
                    Assert.state(propertyAccessor != null, "No cached write accessor");
                    propertyAccessor.write(this.evaluationContext, this.targetObject, this.name, object);
                    return;
                }
                List<PropertyAccessor> list = AstUtils.getPropertyAccessorsToTry(clazz, this.evaluationContext.getPropertyAccessors());
                for (PropertyAccessor propertyAccessor : list) {
                    if (!propertyAccessor.canWrite(this.evaluationContext, this.targetObject, this.name)) continue;
                    Indexer.this.cachedWriteName = this.name;
                    Indexer.this.cachedWriteTargetType = clazz;
                    Indexer.this.cachedWriteAccessor = propertyAccessor;
                    propertyAccessor.write(this.evaluationContext, this.targetObject, this.name, object);
                    return;
                }
            }
            catch (AccessException accessException) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)accessException, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, this.name, accessException.getMessage());
            }
        }
    }

    private class MapIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Map map;
        private final Object key;
        private final TypeDescriptor mapEntryDescriptor;

        public MapIndexingValueRef(TypeConverter typeConverter, Map map, Object object, TypeDescriptor typeDescriptor) {
            this.typeConverter = typeConverter;
            this.map = map;
            this.key = object;
            this.mapEntryDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object v2 = this.map.get(this.key);
            Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
            return new TypedValue(v2, this.mapEntryDescriptor.getMapValueTypeDescriptor(v2));
        }

        @Override
        public void setValue(Object object) {
            if (this.mapEntryDescriptor.getMapValueTypeDescriptor() != null) {
                object = this.typeConverter.convertValue(object, TypeDescriptor.forObject(object), this.mapEntryDescriptor.getMapValueTypeDescriptor());
            }
            this.map.put(this.key, object);
        }
    }

    private class ArrayIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Object array;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        ArrayIndexingValueRef(TypeConverter typeConverter, Object object, int n2, TypeDescriptor typeDescriptor) {
            this.typeConverter = typeConverter;
            this.array = object;
            this.index = n2;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object object = Indexer.this.accessArrayElement(this.array, this.index);
            return new TypedValue(object, this.typeDescriptor.elementTypeDescriptor(object));
        }

        @Override
        public void setValue(Object object) {
            TypeDescriptor typeDescriptor = this.typeDescriptor.getElementTypeDescriptor();
            Assert.state(typeDescriptor != null, "No element type");
            Indexer.this.setArrayElement(this.typeConverter, this.array, this.index, object, typeDescriptor.getType());
        }
    }

    private static enum IndexedType {
        ARRAY,
        LIST,
        MAP,
        STRING,
        OBJECT;

    }
}

