/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionUtils {
    private static Map<PosixFilePermission, Integer> posixPermissionToInteger = new EnumMap<PosixFilePermission, Integer>(PosixFilePermission.class);
    private static final boolean IS_POSIX;
    private static final boolean IS_DOS;

    public static void setPermissions(File file, int mode) throws IOException {
        if (IS_POSIX) {
            Files.setPosixFilePermissions(file.toPath(), PermissionUtils.permissions(mode));
        } else if (IS_DOS) {
            Files.getFileAttributeView(file.toPath(), DosFileAttributeView.class, new LinkOption[0]).setReadOnly((mode & posixPermissionToInteger.get((Object)PosixFilePermission.OWNER_WRITE)) == 0);
        }
    }

    private static Set<PosixFilePermission> permissions(int mode) {
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
        for (Map.Entry<PosixFilePermission, Integer> entry : posixPermissionToInteger.entrySet()) {
            if ((mode & entry.getValue()) == 0) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public static int permissions(File f2) {
        if (f2 == null) {
            throw new NullPointerException("File is null.");
        }
        if (!f2.exists()) {
            throw new IllegalArgumentException("File " + f2 + " does not exist.");
        }
        return IS_POSIX ? PermissionUtils.posixPermissions(f2) : (IS_DOS ? PermissionUtils.dosPermissions(f2) : PermissionUtils.defaultPermissions(f2));
    }

    private static int defaultPermissions(File f2) {
        return f2.isDirectory() ? 493 : 420;
    }

    private static int posixPermissions(File f2) {
        try {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(f2.toPath(), new LinkOption[0]);
            int number = 0;
            for (Map.Entry<PosixFilePermission, Integer> entry : posixPermissionToInteger.entrySet()) {
                if (!permissions.contains((Object)entry.getKey())) continue;
                number += entry.getValue().intValue();
            }
            return number;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private static Set<StandardFilePermission> readDosPermissions(File f2) {
        EnumSet<StandardFilePermission> permissions = EnumSet.allOf(StandardFilePermission.class);
        if (PermissionUtils.readDosFileAttributes(f2).isReadOnly()) {
            permissions.remove((Object)StandardFilePermission.WRITE);
        }
        return permissions;
    }

    private static DosFileAttributes readDosFileAttributes(File f2) {
        try {
            return Files.getFileAttributeView(f2.toPath(), DosFileAttributeView.class, new LinkOption[0]).readAttributes();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private static Integer dosPermissions(File f2) {
        int number = 0;
        Set<StandardFilePermission> permissions = PermissionUtils.readDosPermissions(f2);
        for (StandardFilePermission permission : permissions) {
            number += permission.mode;
        }
        return number;
    }

    static {
        posixPermissionToInteger.put(PosixFilePermission.OWNER_EXECUTE, 64);
        posixPermissionToInteger.put(PosixFilePermission.OWNER_WRITE, 128);
        posixPermissionToInteger.put(PosixFilePermission.OWNER_READ, 256);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_EXECUTE, 8);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_WRITE, 16);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_READ, 32);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_EXECUTE, 1);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_WRITE, 2);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_READ, 4);
        IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        IS_DOS = FileSystems.getDefault().supportedFileAttributeViews().contains("dos");
    }

    private static enum StandardFilePermission {
        EXECUTE(72),
        WRITE(144),
        READ(288);

        private int mode;

        private StandardFilePermission(int mode) {
            this.mode = mode;
        }
    }
}

