/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.JavaVersion;
import org.gradle.internal.jvm.JavaHomeException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jvm
implements JavaInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jvm.class);
    private final OperatingSystem os;
    private final File javaBase;
    private final File javaHome;
    private final boolean userSupplied;
    private final JavaVersion javaVersion;
    private static final AtomicReference<JvmImplementation> CURRENT = new AtomicReference();
    private File javaExecutable;

    public static Jvm current() {
        Jvm jvm = CURRENT.get();
        if (jvm == null) {
            CURRENT.compareAndSet(null, Jvm.create());
            jvm = CURRENT.get();
        }
        return jvm;
    }

    private static JvmImplementation create() {
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor.toLowerCase().startsWith("apple inc.")) {
            return new AppleJvm(OperatingSystem.current());
        }
        if (vendor.toLowerCase().startsWith("ibm corporation")) {
            return new IbmJvm(OperatingSystem.current());
        }
        return new JvmImplementation(OperatingSystem.current());
    }

    static Jvm create(File javaBase, JavaVersion javaVersion) {
        Jvm jvm = new Jvm(OperatingSystem.current(), javaBase, javaVersion);
        Jvm current = Jvm.current();
        return jvm.getJavaHome().equals(current.getJavaHome()) ? current : jvm;
    }

    Jvm(OperatingSystem os) {
        this(os, new File(System.getProperty("java.home")), JavaVersion.current(), false);
    }

    Jvm(OperatingSystem os, File suppliedJavaBase, JavaVersion javaVersion) {
        this(os, suppliedJavaBase, javaVersion, true);
    }

    private Jvm(OperatingSystem os, File suppliedJavaBase, JavaVersion javaVersion, boolean userSupplied) {
        this.os = os;
        this.javaBase = suppliedJavaBase;
        this.javaHome = this.findJavaHome(suppliedJavaBase);
        this.javaVersion = javaVersion;
        this.userSupplied = userSupplied;
    }

    public static JavaInfo forHome(File javaHome) throws JavaHomeException, IllegalArgumentException {
        if (javaHome == null || !javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome must be a valid directory. You supplied: " + javaHome);
        }
        Jvm jvm = Jvm.create(javaHome, null);
        jvm.getJavaExecutable();
        return jvm;
    }

    public String toString() {
        if (this.userSupplied) {
            return "User-supplied java: " + this.javaBase;
        }
        return System.getProperty("java.version") + " (" + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version") + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Jvm other = (Jvm)obj;
        return other.javaHome.equals(this.javaHome);
    }

    public int hashCode() {
        return this.javaHome.hashCode();
    }

    private File findExecutable(String command) {
        File exec = new File(this.getJavaHome(), "bin/" + command);
        File executable = new File(this.os.getExecutableName(exec.getAbsolutePath()));
        if (executable.isFile()) {
            return executable;
        }
        if (this.userSupplied) {
            throw new JavaHomeException(String.format("The supplied javaHome seems to be invalid. I cannot find the %s executable. Tried location: %s", command, executable.getAbsolutePath()));
        }
        File pathExecutable = this.os.findInPath(command);
        if (pathExecutable != null) {
            LOGGER.info(String.format("Unable to find the '%s' executable using home: %s. We found it on the PATH: %s.", command, this.getJavaHome(), pathExecutable));
            return pathExecutable;
        }
        LOGGER.warn("Unable to find the '{}' executable. Tried the java home: {} and the PATH. We will assume the executable can be ran in the current working folder.", (Object)command, (Object)this.getJavaHome());
        return new File(this.os.getExecutableName(command));
    }

    @Override
    public File getJavaExecutable() throws JavaHomeException {
        if (this.javaExecutable != null) {
            return this.javaExecutable;
        }
        this.javaExecutable = this.findExecutable("java");
        return this.javaExecutable;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    private File findJavaHome(File javaBase) {
        File toolsJar = this.findToolsJar(javaBase);
        if (toolsJar != null) {
            return toolsJar.getParentFile().getParentFile();
        }
        if (javaBase.getName().equalsIgnoreCase("jre") && new File(javaBase.getParentFile(), "bin/java").exists()) {
            return javaBase.getParentFile();
        }
        return javaBase;
    }

    private File findToolsJar(File javaHome) {
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar;
        }
        if (javaHome.getName().equalsIgnoreCase("jre") && (toolsJar = new File(javaHome = javaHome.getParentFile(), "lib/tools.jar")).exists()) {
            return toolsJar;
        }
        if (this.os.isWindows()) {
            String version = System.getProperty("java.version");
            if ((javaHome.getName().matches("jre\\d+") || javaHome.getName().equals("jre" + version)) && (toolsJar = new File(javaHome = new File(javaHome.getParentFile(), "jdk" + version), "lib/tools.jar")).exists()) {
                return toolsJar;
            }
        }
        return null;
    }

    static class AppleJvm
    extends JvmImplementation {
        AppleJvm(OperatingSystem os) {
            super(os);
        }
    }

    static class IbmJvm
    extends JvmImplementation {
        IbmJvm(OperatingSystem os) {
            super(os);
        }
    }

    static class JvmImplementation
    extends Jvm {
        JvmImplementation(OperatingSystem os) {
            super(os);
        }
    }
}

