/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.os;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class OperatingSystem {
    public static final Windows WINDOWS = new Windows();
    public static final MacOs MAC_OS = new MacOs();
    public static final Solaris SOLARIS = new Solaris();
    public static final Linux LINUX = new Linux();
    public static final FreeBSD FREE_BSD = new FreeBSD();
    public static final Unix UNIX = new Unix();
    private static OperatingSystem currentOs;
    private final String toStringValue;
    private final String osName = System.getProperty("os.name");
    private final String osVersion = System.getProperty("os.version");

    OperatingSystem() {
        this.toStringValue = this.getName() + " " + this.getVersion() + " " + System.getProperty("os.arch");
    }

    public static OperatingSystem current() {
        if (currentOs == null) {
            currentOs = OperatingSystem.forName(System.getProperty("os.name"));
        }
        return currentOs;
    }

    public static OperatingSystem forName(String os) {
        String osName = os.toLowerCase();
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            return MAC_OS;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("freebsd")) {
            return FREE_BSD;
        }
        return UNIX;
    }

    public String toString() {
        return this.toStringValue;
    }

    public String getName() {
        return this.osName;
    }

    public String getVersion() {
        return this.osVersion;
    }

    public boolean isWindows() {
        return false;
    }

    public abstract String getExecutableName(String var1);

    public File findInPath(String name) {
        String exeName = this.getExecutableName(name);
        if (exeName.contains(File.separator)) {
            File candidate = new File(exeName);
            if (candidate.isFile()) {
                return candidate;
            }
            return null;
        }
        for (File dir : this.getPath()) {
            File candidate = new File(dir, exeName);
            if (!candidate.isFile()) continue;
            return candidate;
        }
        return null;
    }

    public List<File> getPath() {
        String path = System.getenv(this.getPathVar());
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<File> entries = new ArrayList<File>();
        for (String entry : path.split(Pattern.quote(File.pathSeparator))) {
            entries.add(new File(entry));
        }
        return entries;
    }

    public String getPathVar() {
        return "PATH";
    }

    static class Solaris
    extends Unix {
        Solaris() {
        }

        @Override
        protected String getOsPrefix() {
            return "sunos";
        }

        @Override
        protected String getArch() {
            String arch = System.getProperty("os.arch");
            if (arch.equals("i386") || arch.equals("x86")) {
                return "x86";
            }
            return super.getArch();
        }
    }

    static class FreeBSD
    extends Unix {
        FreeBSD() {
        }
    }

    static class Linux
    extends Unix {
        Linux() {
        }
    }

    static class MacOs
    extends Unix {
        MacOs() {
        }
    }

    static class Unix
    extends OperatingSystem {
        private final String nativePrefix = this.resolveNativePrefix();

        Unix() {
        }

        @Override
        public String getExecutableName(String executablePath) {
            return executablePath;
        }

        private String resolveNativePrefix() {
            String arch = this.getArch();
            String osPrefix = this.getOsPrefix();
            osPrefix = osPrefix + "-" + arch;
            return osPrefix;
        }

        protected String getArch() {
            String arch = System.getProperty("os.arch");
            if ("x86".equals(arch)) {
                arch = "i386";
            }
            if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            if ("powerpc".equals(arch)) {
                arch = "ppc";
            }
            return arch;
        }

        protected String getOsPrefix() {
            String osPrefix = this.getName().toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            return osPrefix;
        }
    }

    static class Windows
    extends OperatingSystem {
        private final String nativePrefix = this.resolveNativePrefix();

        Windows() {
        }

        @Override
        public boolean isWindows() {
            return true;
        }

        @Override
        public String getExecutableName(String executablePath) {
            return executablePath + ".exe";
        }

        private String resolveNativePrefix() {
            String arch = System.getProperty("os.arch");
            if ("i386".equals(arch)) {
                arch = "x86";
            }
            return "win32-" + arch;
        }

        @Override
        public String getPathVar() {
            return "Path";
        }
    }
}

