/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.BasicHeader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;

class HeaderDeserializer
extends StdDeserializer<BasicHeader> {
    private final ObjectReader objectReader;

    HeaderDeserializer(ObjectReader objectReader) {
        this(null, objectReader);
    }

    private HeaderDeserializer(Class<?> vc, ObjectReader objectReader) {
        super(vc);
        this.objectReader = objectReader;
    }

    @Override
    public BasicHeader deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Map tree = (Map)p2.getCodec().readValue(p2, new TypeReference<Map<String, JsonNode>>(){});
        if (tree == null) {
            throw new JWTDecodeException("Parsing the Header's JSON resulted on a Null map");
        }
        String algorithm = this.getString(tree, "alg");
        String type = this.getString(tree, "typ");
        String contentType = this.getString(tree, "cty");
        String keyId = this.getString(tree, "kid");
        return new BasicHeader(algorithm, type, contentType, keyId, tree, this.objectReader);
    }

    String getString(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText(null);
    }
}

