/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.scan.extension.test.event.internal;

import com.gradle.maven.scan.extension.test.event.TestFinishedEvent;
import com.gradle.maven.scan.extension.test.event.internal.TestDescriptor;
import com.gradle.maven.scan.extension.test.event.internal.TestResult;
import com.gradle.maven.scan.extension.test.event.internal.TestState;

public final class DefaultTestState
implements TestState {
    public final TestDescriptor test;
    private boolean isFailed;
    private boolean isAssumptionFailed;
    private Throwable failure;
    private Throwable assumptionFailure;
    private TestResult.ResultType resultType;

    public DefaultTestState(TestDescriptor test) {
        this.test = test;
    }

    public void completed(TestFinishedEvent event) {
        this.resultType = this.isFailed ? TestResult.ResultType.FAILURE : (this.isAssumptionFailed ? TestResult.ResultType.ABORTED : (event.testResult.getResultType() != null ? event.testResult.getResultType() : TestResult.ResultType.SUCCESS));
    }

    @Override
    public Throwable getFailure() {
        return this.failure != null ? this.failure : this.assumptionFailure;
    }

    @Override
    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public void addFailure(Throwable failure) {
        this.isFailed = true;
        if (this.failure == null) {
            this.failure = failure;
        }
    }

    public void addAssumptionFailure(Throwable assumptionFailure) {
        this.isAssumptionFailed = true;
        if (this.assumptionFailure == null) {
            this.assumptionFailure = assumptionFailure;
        }
    }
}

