/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Strings;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.io.CountingOutputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.CloseShieldInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.impl.PackerDirectoryUtil;
import org.gradle.caching.internal.packaging.impl.PermissionUtils;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileMetadata;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class TarBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private static final Pattern TREE_PATH = Pattern.compile("(missing-)?tree-([^/]+)(?:/(.*))?");
    private static final ThreadLocal<byte[]> COPY_BUFFERS = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };
    private final StreamHasher streamHasher;
    private final Interner<String> stringInterner;
    private final OperatingSystem operatingSystem = OperatingSystem.current();

    @Inject
    public TarBuildCacheEntryPacker(StreamHasher streamHasher, Interner<String> stringInterner) {
        this.streamHasher = streamHasher;
        this.stringInterner = stringInterner;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, OutputStream output, OriginWriter writeOrigin) throws IOException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        try (TarArchiveOutputStream tarOutput = new TarArchiveOutputStream(bufferedOutput, "utf-8");){
            tarOutput.setLongFileMode(3);
            tarOutput.setBigNumberMode(2);
            tarOutput.setAddPaxHeadersForNonAsciiNames(true);
            this.packMetadata(writeOrigin, tarOutput);
            long entryCount = this.pack(entity, fingerprints, tarOutput);
            BuildCacheEntryPacker.PackResult packResult = new BuildCacheEntryPacker.PackResult(entryCount + 1L);
            return packResult;
        }
    }

    private void packMetadata(OriginWriter writeMetadata, TarArchiveOutputStream tarOutput) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute(baos);
        TarBuildCacheEntryPacker.createTarEntry("METADATA", baos.size(), 33188, tarOutput);
        tarOutput.write(baos.toByteArray());
        tarOutput.closeArchiveEntry();
    }

    private long pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, TarArchiveOutputStream tarOutput) {
        AtomicLong entries = new AtomicLong();
        entity.visitTrees((treeName, type, root) -> {
            if (root == null) {
                return;
            }
            CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)fingerprints.get(treeName);
            try {
                entries.addAndGet(this.packTree(treeName, type, fingerprint, tarOutput));
            }
            catch (Exception ex) {
                throw new BuildCacheException(String.format("Could not pack tree '%s': %s", treeName, ex.getMessage()), ex);
            }
        });
        return entries.get();
    }

    private long packTree(String name, TreeType type, CurrentFileCollectionFingerprint fingerprint, TarArchiveOutputStream tarOutput) {
        PackingVisitor packingVisitor = new PackingVisitor(tarOutput, name, type);
        fingerprint.accept(new SymbolicLinkHandlingDecorator(packingVisitor));
        return packingVisitor.finish();
    }

    private static void createTarEntry(String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path, true);
        entry.setSize(size);
        entry.setMode(mode);
        tarOutput.putArchiveEntry(entry);
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, InputStream input, OriginReader readOrigin) throws IOException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(input);){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.unpack(entity, tarInput, readOrigin);
            return unpackResult;
        }
    }

    private BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, TarArchiveInputStream tarInput, OriginReader readOriginAction) throws IOException {
        ImmutableMap.Builder treesBuilder = ImmutableMap.builder();
        entity.visitTrees((name, type, root) -> {
            if (root != null) {
                treesBuilder.put(name, new CacheableTree(type, root));
            }
        });
        ImmutableMap<String, CacheableTree> treesByName = treesBuilder.build();
        HashMap<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();
        AtomicLong entries = new AtomicLong();
        OriginMetadata originMetadata = this.readEntries(tarInput, readOriginAction, treesByName, snapshots, entries);
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new BuildCacheEntryPacker.UnpackResult(originMetadata, entries.get(), snapshots);
    }

    private OriginMetadata readEntries(TarArchiveInputStream tarInput, OriginReader readOriginAction, ImmutableMap<String, CacheableTree> treesByName, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries) throws IOException {
        TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
        OriginMetadata originMetadata = null;
        while (tarEntry != null) {
            entries.addAndGet(1L);
            String path = tarEntry.getName();
            if (path.equals("METADATA")) {
                originMetadata = readOriginAction.execute(new CloseShieldInputStream(tarInput));
                tarEntry = tarInput.getNextTarEntry();
                continue;
            }
            Matcher matcher = TREE_PATH.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached entry format error, invalid contents: " + path);
            }
            String treeName = TarBuildCacheEntryPacker.unescape(matcher.group(2));
            CacheableTree tree = treesByName.get(treeName);
            if (tree == null) {
                throw new IllegalStateException(String.format("No tree '%s' registered", treeName));
            }
            boolean missing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            tarEntry = this.unpackTree(treeName, tree.getType(), tree.getRoot(), tarInput, tarEntry, childPath, missing, snapshots, entries);
        }
        return originMetadata;
    }

    private TarArchiveEntry unpackTree(String treeName, TreeType treeType, File treeRoot, TarArchiveInputStream input, TarArchiveEntry rootEntry, String childPath, boolean missing, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries) throws IOException {
        boolean isDirEntry = rootEntry.isDirectory();
        boolean root = Strings.isNullOrEmpty(childPath);
        if (!root) {
            throw new IllegalStateException("Root needs to be the first entry in a tree");
        }
        if (missing) {
            return input.getNextTarEntry();
        }
        PackerDirectoryUtil.ensureDirectoryForTree(treeType, treeRoot);
        if (treeType == TreeType.FILE) {
            if (isDirEntry) {
                throw new IllegalStateException("Should be a file: " + treeName);
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, rootEntry, treeRoot, treeRoot.getName());
            snapshots.put(treeName, fileSnapshot);
            return input.getNextTarEntry();
        }
        if (!isDirEntry) {
            throw new IllegalStateException("Should be a directory: " + treeName);
        }
        this.chmodUnpackedFile(rootEntry, treeRoot);
        return this.unpackDirectoryTree(input, rootEntry, snapshots, entries, treeRoot, treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegularFileSnapshot unpackFile(TarArchiveInputStream input, TarArchiveEntry entry, File file, String fileName) throws IOException {
        HashCode hash;
        CountingOutputStream output = new CountingOutputStream(new FileOutputStream(file));
        try {
            hash = this.streamHasher.hashCopy(input, output);
            this.chmodUnpackedFile(entry, file);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
        String internedFileName = this.stringInterner.intern(fileName);
        FileMetadata metadata = new FileMetadata(output.getCount(), System.currentTimeMillis());
        return new RegularFileSnapshot(internedAbsolutePath, internedFileName, hash, metadata);
    }

    private TarArchiveEntry unpackDirectoryTree(TarArchiveInputStream input, TarArchiveEntry rootEntry, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries, File treeRoot, String treeName) throws IOException {
        TarArchiveEntry entry;
        RelativePathParser parser = new RelativePathParser();
        parser.rootPath(rootEntry.getName());
        MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        String rootPath = this.stringInterner.intern(treeRoot.getAbsolutePath());
        String rootDirName = this.stringInterner.intern(treeRoot.getName());
        builder.preVisitDirectory(rootPath, rootDirName);
        while ((entry = input.getNextTarEntry()) != null) {
            boolean isDir = entry.isDirectory();
            int directoriesLeft = parser.nextPath(entry.getName(), isDir);
            for (int i2 = 0; i2 < directoriesLeft; ++i2) {
                builder.postVisitDirectory();
            }
            if (parser.getDepth() == 0) break;
            entries.addAndGet(1L);
            File file = new File(treeRoot, parser.getRelativePath());
            if (isDir) {
                FileUtils.forceMkdir(file);
                this.chmodUnpackedFile(entry, file);
                String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
                String indernedDirName = this.stringInterner.intern(parser.getName());
                builder.preVisitDirectory(internedAbsolutePath, indernedDirName);
                continue;
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, entry, file, parser.getName());
            builder.visitFile(fileSnapshot);
        }
        for (int i3 = 0; i3 < parser.getDepth(); ++i3) {
            builder.postVisitDirectory();
        }
        snapshots.put(treeName, builder.getResult());
        return entry;
    }

    private void chmodUnpackedFile(TarArchiveEntry entry, File file) {
        try {
            PermissionUtils.setPermissions(file, entry.getMode() & 0xFFF);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private static String escape(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new AssertionError();
        }
    }

    private static String unescape(String name) {
        try {
            return URLDecoder.decode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    private static class SymbolicLinkHandlingDecorator
    implements FileSystemSnapshotVisitor {
        private final FileSystemSnapshotVisitor delegate;

        private SymbolicLinkHandlingDecorator(FileSystemSnapshotVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            return this.delegate.preVisitDirectory(directorySnapshot);
        }

        @Override
        public void visitFile(FileSystemLocationSnapshot fileSnapshot) {
            boolean isSymbolicLink = Files.isSymbolicLink(Paths.get(fileSnapshot.getAbsolutePath(), new String[0]));
            if (isSymbolicLink && fileSnapshot.getType() == FileType.Missing) {
                throw new IllegalStateException("Couldn't read content of file '" + fileSnapshot.getAbsolutePath() + "' - broken symbolic link");
            }
            this.delegate.visitFile(fileSnapshot);
        }

        @Override
        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.delegate.postVisitDirectory(directorySnapshot);
        }
    }

    private static class PackingVisitor
    implements FileSystemSnapshotVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final TarArchiveOutputStream tarOutput;
        private final String treePath;
        private final String treeRoot;
        private final TreeType type;
        private long entries;

        public PackingVisitor(TarArchiveOutputStream tarOutput, String treeName, TreeType type) {
            this.tarOutput = tarOutput;
            this.treePath = "tree-" + TarBuildCacheEntryPacker.escape(treeName);
            this.treeRoot = this.treePath + "/";
            this.type = type;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        @Override
        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            boolean root = this.relativePathStringTracker.isRoot();
            this.relativePathStringTracker.enter(directorySnapshot);
            this.assertCorrectType(root, directorySnapshot);
            String targetPath = this.getTargetPath(root);
            int mode = root ? 493 : PermissionUtils.permissions(new File(directorySnapshot.getAbsolutePath()));
            this.storeDirectoryEntry(targetPath, mode, this.tarOutput);
            ++this.entries;
            return true;
        }

        @Override
        public void visitFile(FileSystemLocationSnapshot fileSnapshot) {
            boolean root = this.relativePathStringTracker.isRoot();
            this.relativePathStringTracker.enter(fileSnapshot);
            String targetPath = this.getTargetPath(root);
            if (fileSnapshot.getType() == FileType.Missing) {
                this.storeMissingTree(targetPath, this.tarOutput);
            } else {
                this.assertCorrectType(root, fileSnapshot);
                File file = new File(fileSnapshot.getAbsolutePath());
                int mode = PermissionUtils.permissions(file);
                this.storeFileEntry(file, targetPath, file.length(), mode, this.tarOutput);
            }
            this.relativePathStringTracker.leave();
            ++this.entries;
        }

        @Override
        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.relativePathStringTracker.leave();
        }

        public long finish() {
            if (this.entries == 0L) {
                this.storeMissingTree(this.treePath, this.tarOutput);
                ++this.entries;
            }
            return this.entries;
        }

        private void assertCorrectType(boolean root, FileSystemLocationSnapshot snapshot) {
            if (root) {
                switch (this.type) {
                    case DIRECTORY: {
                        if (snapshot.getType() == FileType.Directory) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
                    }
                    case FILE: {
                        if (snapshot.getType() == FileType.RegularFile) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        private String getTargetPath(boolean root) {
            if (root) {
                return this.treePath;
            }
            String relativePath = this.relativePathStringTracker.getRelativePathString();
            return this.treeRoot + relativePath;
        }

        private void storeMissingTree(String treePath, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry("missing-" + treePath, 0L, 33188, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        private void storeDirectoryEntry(String path, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path + "/", 0L, 0x4000 | mode, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        private void storeFileEntry(File inputFile, String path, long size, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path, size, 0x8000 | mode, tarOutput);
                try (FileInputStream input = new FileInputStream(inputFile);){
                    IOUtils.copyLarge(input, tarOutput, (byte[])COPY_BUFFERS.get());
                }
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    private static class CacheableTree {
        private final TreeType type;
        private final File root;

        public CacheableTree(TreeType type, File root) {
            this.type = type;
            this.root = root;
        }

        public TreeType getType() {
            return this.type;
        }

        public File getRoot() {
            return this.root;
        }
    }
}

