/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.base;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.JsonEOFException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final byte[] NO_BYTES = new byte[0];
    protected static final int[] NO_INTS = new int[0];
    protected static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    protected static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    protected static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    protected static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    protected static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    protected static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase(int features) {
        super(features);
    }

    @Override
    public abstract JsonToken nextToken() throws IOException;

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public int getCurrentTokenId() {
        JsonToken t2 = this._currToken;
        return t2 == null ? 0 : t2.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int id) {
        JsonToken t2 = this._currToken;
        if (t2 == null) {
            return 0 == id;
        }
        return t2.id() == id;
    }

    @Override
    public boolean hasToken(JsonToken t2) {
        return this._currToken == t2;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public JsonToken nextValue() throws IOException {
        JsonToken t2 = this.nextToken();
        if (t2 == JsonToken.FIELD_NAME) {
            t2 = this.nextToken();
        }
        return t2;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t2;
            if ((t2 = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (t2.isStructStart()) {
                ++open;
                continue;
            }
            if (t2.isStructEnd()) {
                if (--open != 0) continue;
                return this;
            }
            if (t2 != JsonToken.NOT_AVAILABLE) continue;
            this._reportError("Not enough content available for `skipChildren()`: non-blocking parser? (%s)", this.getClass().getName());
        }
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    public abstract String getCurrentName() throws IOException;

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public abstract String getText() throws IOException;

    @Override
    public int getValueAsInt() throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 == JsonToken.VALUE_NUMBER_INT || t2 == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        return this.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int defaultValue) throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 == JsonToken.VALUE_NUMBER_INT || t2 == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        if (t2 != null) {
            switch (t2.id()) {
                case 6: {
                    String str = this.getText();
                    if (this._hasTextualNull(str)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt(str, defaultValue);
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).intValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public long getValueAsLong() throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 == JsonToken.VALUE_NUMBER_INT || t2 == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        return this.getValueAsLong(0L);
    }

    @Override
    public long getValueAsLong(long defaultValue) throws IOException {
        JsonToken t2 = this._currToken;
        if (t2 == JsonToken.VALUE_NUMBER_INT || t2 == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        if (t2 != null) {
            switch (t2.id()) {
                case 6: {
                    String str = this.getText();
                    if (this._hasTextualNull(str)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong(str, defaultValue);
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).longValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String defaultValue) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return defaultValue;
        }
        return this.getText();
    }

    protected void _decodeBase64(String str, ByteArrayBuilder builder, Base64Variant b64variant) throws IOException {
        try {
            b64variant.decode(str, builder);
        }
        catch (IllegalArgumentException e2) {
            this._reportError(e2.getMessage());
        }
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected void reportUnexpectedNumberChar(int ch, String comment) throws JsonParseException {
        String msg = String.format("Unexpected character (%s) in numeric value", ParserMinimalBase._getCharDesc(ch));
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        this._reportError(msg);
    }

    protected void reportInvalidNumber(String msg) throws JsonParseException {
        this._reportError("Invalid numeric value: " + msg);
    }

    protected void reportOverflowInt() throws IOException {
        this._reportError(String.format("Numeric value (%s) out of range of int (%d - %s)", this._longIntegerDesc(this.getText()), Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    protected void reportOverflowLong() throws IOException {
        this._reportError(String.format("Numeric value (%s) out of range of long (%d - %s)", this._longIntegerDesc(this.getText()), Long.MIN_VALUE, Long.MAX_VALUE));
    }

    protected String _longIntegerDesc(String rawNum) {
        int rawLen = rawNum.length();
        if (rawLen < 1000) {
            return rawNum;
        }
        if (rawNum.startsWith("-")) {
            --rawLen;
        }
        return String.format("[Integer with %d digits]", rawLen);
    }

    protected String _longNumberDesc(String rawNum) {
        int rawLen = rawNum.length();
        if (rawLen < 1000) {
            return rawNum;
        }
        if (rawNum.startsWith("-")) {
            --rawLen;
        }
        return String.format("[number with %d characters]", rawLen);
    }

    protected void _reportUnexpectedChar(int ch, String comment) throws JsonParseException {
        if (ch < 0) {
            this._reportInvalidEOF();
        }
        String msg = String.format("Unexpected character (%s)", ParserMinimalBase._getCharDesc(ch));
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        this._reportError(msg);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken), this._currToken);
    }

    protected void _reportInvalidEOFInValue(JsonToken type) throws JsonParseException {
        String msg = type == JsonToken.VALUE_STRING ? " in a String value" : (type == JsonToken.VALUE_NUMBER_INT || type == JsonToken.VALUE_NUMBER_FLOAT ? " in a Number value" : " in a value");
        this._reportInvalidEOF(msg, type);
    }

    protected void _reportInvalidEOF(String msg, JsonToken currToken) throws JsonParseException {
        throw new JsonEOFException((JsonParser)this, currToken, "Unexpected end-of-input" + msg);
    }

    protected void _reportMissingRootWS(int ch) throws JsonParseException {
        this._reportUnexpectedChar(ch, "Expected space separating root-level values");
    }

    protected void _throwInvalidSpace(int i2) throws JsonParseException {
        char c2 = (char)i2;
        String msg = "Illegal character (" + ParserMinimalBase._getCharDesc(c2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(msg);
    }

    protected void _throwUnquotedSpace(int i2, String ctxtDesc) throws JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || i2 > 32) {
            char c2 = (char)i2;
            String msg = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c2) + "): has to be escaped using backslash to be included in " + ctxtDesc;
            this._reportError(msg);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char ch) throws JsonProcessingException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return ch;
        }
        if (ch == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return ch;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(ch));
        return ch;
    }

    protected static final String _getCharDesc(int ch) {
        char c2 = (char)ch;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + ch + ")";
        }
        if (ch > 255) {
            return "'" + c2 + "' (code " + ch + " / 0x" + Integer.toHexString(ch) + ")";
        }
        return "'" + c2 + "' (code " + ch + ")";
    }

    protected final void _reportError(String msg) throws JsonParseException {
        throw this._constructError(msg);
    }

    protected final void _reportError(String msg, Object arg) throws JsonParseException {
        throw this._constructError(String.format(msg, arg));
    }

    protected final void _reportError(String msg, Object arg1, Object arg2) throws JsonParseException {
        throw this._constructError(String.format(msg, arg1, arg2));
    }

    protected final void _wrapError(String msg, Throwable t2) throws JsonParseException {
        throw this._constructError(msg, t2);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final JsonParseException _constructError(String msg, Throwable t2) {
        return new JsonParseException(this, msg, t2);
    }
}

