/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.BufferRecyclers;
import java.io.Serializable;

public class SerializedString
implements SerializableString,
Serializable {
    protected final String _value;
    protected byte[] _quotedUTF8Ref;
    protected byte[] _unquotedUTF8Ref;
    protected char[] _quotedChars;

    public SerializedString(String v2) {
        if (v2 == null) {
            throw new IllegalStateException("Null String illegal for SerializedString");
        }
        this._value = v2;
    }

    @Override
    public final String getValue() {
        return this._value;
    }

    @Override
    public final int charLength() {
        return this._value.length();
    }

    @Override
    public final char[] asQuotedChars() {
        char[] result = this._quotedChars;
        if (result == null) {
            this._quotedChars = result = BufferRecyclers.quoteAsJsonText(this._value);
        }
        return result;
    }

    @Override
    public final byte[] asUnquotedUTF8() {
        byte[] result = this._unquotedUTF8Ref;
        if (result == null) {
            this._unquotedUTF8Ref = result = BufferRecyclers.encodeAsUTF8(this._value);
        }
        return result;
    }

    @Override
    public final byte[] asQuotedUTF8() {
        byte[] result = this._quotedUTF8Ref;
        if (result == null) {
            this._quotedUTF8Ref = result = BufferRecyclers.quoteAsJsonUTF8(this._value);
        }
        return result;
    }

    @Override
    public int appendQuotedUTF8(byte[] buffer, int offset) {
        int length;
        byte[] result = this._quotedUTF8Ref;
        if (result == null) {
            this._quotedUTF8Ref = result = BufferRecyclers.quoteAsJsonUTF8(this._value);
        }
        if (offset + (length = result.length) > buffer.length) {
            return -1;
        }
        System.arraycopy(result, 0, buffer, offset, length);
        return length;
    }

    public final String toString() {
        return this._value;
    }

    public final int hashCode() {
        return this._value.hashCode();
    }

    public final boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null || o2.getClass() != this.getClass()) {
            return false;
        }
        SerializedString other = (SerializedString)o2;
        return this._value.equals(other._value);
    }
}

