/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import java.util.List;

public abstract class PatternMatcher {
    public static final PatternMatcher MATCH_ALL = new PatternMatcher(){

        @Override
        public boolean test(String[] segments, boolean isFile) {
            return true;
        }

        @Override
        public PatternMatcher and(PatternMatcher other) {
            return other;
        }

        @Override
        public PatternMatcher or(PatternMatcher other) {
            return this;
        }
    };

    public abstract boolean test(String[] var1, boolean var2);

    public PatternMatcher and(PatternMatcher other) {
        return new And(this, other);
    }

    public PatternMatcher or(PatternMatcher other) {
        return new Or(this, other);
    }

    public PatternMatcher negate() {
        return new PatternMatcher(){

            @Override
            public boolean test(String[] segments, boolean isFile) {
                return !PatternMatcher.this.test(segments, isFile);
            }
        };
    }

    private static final class And
    extends PatternMatcher {
        private final List<PatternMatcher> parts = Lists.newLinkedList();

        public And(PatternMatcher patternMatcher, PatternMatcher other) {
            this.parts.add(patternMatcher);
            this.parts.add(other);
        }

        @Override
        public PatternMatcher and(PatternMatcher other) {
            this.parts.add(other);
            return this;
        }

        @Override
        public boolean test(String[] segments, boolean isFile) {
            for (PatternMatcher part : this.parts) {
                if (part.test(segments, isFile)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Or
    extends PatternMatcher {
        private final List<PatternMatcher> parts = Lists.newLinkedList();

        public Or(PatternMatcher patternMatcher, PatternMatcher other) {
            this.parts.add(patternMatcher);
            this.parts.add(other);
        }

        @Override
        public PatternMatcher or(PatternMatcher other) {
            this.parts.add(other);
            return this;
        }

        @Override
        public boolean test(String[] segments, boolean isFile) {
            for (PatternMatcher part : this.parts) {
                if (!part.test(segments, isFile)) continue;
                return true;
            }
            return false;
        }
    }
}

