/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import java.util.Deque;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;

public class RelativePathSegmentsTracker {
    private final Deque<String> relativePath = Lists.newLinkedList();
    private String rootName;

    public void enter(CompleteFileSystemLocationSnapshot snapshot) {
        this.enter(snapshot.getName());
    }

    public void enter(String name) {
        if (this.rootName == null) {
            this.rootName = name;
        } else {
            this.relativePath.addLast(name);
        }
    }

    public String leave() {
        if (this.relativePath.isEmpty()) {
            String currentRootName = this.rootName;
            this.rootName = null;
            return currentRootName;
        }
        return this.relativePath.removeLast();
    }

    public Iterable<String> getRelativePath() {
        return this.relativePath;
    }

    public boolean isRoot() {
        return this.rootName == null;
    }
}

