/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.common.configuration.model;

import com.gradle.maven.common.configuration.model.ServerConfiguration;
import com.gradle.maven.common.i.b;
import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ObjectUtils;
import java.net.URI;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public class GradleEnterpriseServerConfiguration {
    private final boolean offline;
    private final URI url;
    private final Proxy proxy;
    private final boolean allowUntrustedServer;

    private GradleEnterpriseServerConfiguration(boolean offline, URI url, Proxy proxy, boolean allowUntrustedServer) {
        this.offline = offline;
        this.url = url;
        this.proxy = proxy;
        this.allowUntrustedServer = allowUntrustedServer;
    }

    public static GradleEnterpriseServerConfiguration from(ServerConfiguration serverConfig, MavenExecutionRequest request, SettingsDecrypter settingsDecrypter) {
        URI url = serverConfig.url;
        if (url != null && !url.toString().endsWith("/")) {
            url = URI.create(url + "/");
        }
        Proxy proxy = b.a(request, settingsDecrypter, url);
        Boolean allowUntrustedServer = ObjectUtils.defaultIfNull(serverConfig.allowUntrusted, false);
        return new GradleEnterpriseServerConfiguration(request.isOffline(), url, proxy, allowUntrustedServer);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public URI getUrl() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean isAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }
}

