/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.PlexusResource;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.ResourceManager;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceLoader;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import java.io.File;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ResourceManager.class, instantiationStrategy="per-lookup")
public class DefaultResourceManager
extends AbstractLogEnabled
implements ResourceManager {
    @Requirement(role=ResourceLoader.class)
    private Map<String, ResourceLoader> resourceLoaders;
    private File outputDirectory;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void addSearchPath(String id, String path) {
        ResourceLoader loader = this.resourceLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("unknown resource loader: " + id);
        }
        loader.addSearchPath(path);
    }

    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            try {
                PlexusResource resource = resourceLoader.getResource(name);
                this.getLogger().debug("The resource '" + name + "' was found as " + resource.getName() + ".");
                return resource;
            }
            catch (ResourceNotFoundException e2) {
                this.getLogger().debug("The resource '" + name + "' was not found with resourceLoader " + resourceLoader.getClass().getName() + ".");
            }
        }
        throw new ResourceNotFoundException(name);
    }
}

