/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.FingerprintCache;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class CachingRegularFileHasher
implements RegularFileHasher {
    private final RegularFileHasher delegate;
    private final HashCode delegateHash;
    private final FingerprintCache hashes;

    public CachingRegularFileHasher(RegularFileHasher delegate, FingerprintCache cache) {
        this.delegate = delegate;
        if (delegate instanceof ConfigurableNormalizer) {
            Hasher hasher = Hashing.newHasher();
            ((ConfigurableNormalizer)((Object)delegate)).appendConfigurationToHasher(hasher);
            this.delegateHash = hasher.hash();
        } else {
            this.delegateHash = null;
        }
        this.hashes = cache;
    }

    @Override
    public HashCode hash(RegularFileSnapshot snapshot) {
        HashCode hash = snapshot.getHash();
        if (this.delegateHash != null) {
            Hasher hasher = Hashing.newHasher();
            hasher.putHash(this.delegateHash);
            hasher.putHash(hash);
            hash = hasher.hash();
        }
        return this.hashes.computeIfAbsent(snapshot.getAbsolutePath(), hash, hashCode -> this.delegate.hash(snapshot));
    }
}

