/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import org.gradle.api.internal.changedetection.state.JdkZipEntry;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.api.internal.changedetection.state.ZipInput;

class FileZipInput
implements ZipInput {
    private final ZipFile file;
    private final Enumeration<? extends java.util.zip.ZipEntry> entries;

    public FileZipInput(File file) throws IOException {
        this.file = new ZipFile(file);
        this.entries = this.file.entries();
    }

    @Override
    public ZipEntry getNextEntry() {
        if (this.entries.hasMoreElements()) {
            java.util.zip.ZipEntry zipEntry = this.entries.nextElement();
            return new JdkZipEntry(zipEntry, () -> {
                try {
                    return this.file.getInputStream(zipEntry);
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            });
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

