/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.command;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.command.BuildCacheLoadListener;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildCacheCommandFactory
implements BuildCacheCommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildCacheCommandFactory.class);
    private BuildCacheEntryPacker packer;
    private OriginMetadataFactory originMetadataFactory;
    private Interner<String> stringInterner;

    @Inject
    public DefaultBuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, Interner<String> stringInterner) {
        this.packer = packer;
        this.originMetadataFactory = originMetadataFactory;
        this.stringInterner = stringInterner;
    }

    @Override
    public BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> createLoad(BuildCacheKey cacheKey, CacheableEntity entity, Iterable<File> localState, BuildCacheLoadListener loadListener) {
        return new LoadCommand(cacheKey, entity, localState, loadListener);
    }

    @Override
    public BuildCacheStoreCommand createStore(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
        return new StoreCommand(cacheKey, entity, fingerprints, executionTime);
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Map<String, CurrentFileCollectionFingerprint> fingerprints;
        private final long executionTime;

        private StoreCommand(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.fingerprints = fingerprints;
            this.executionTime = executionTime;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            LOGGER.debug("Packing {}", (Object)this.entity.getDisplayName());
            final BuildCacheEntryPacker.PackResult packResult = DefaultBuildCacheCommandFactory.this.packer.pack(this.entity, this.fingerprints, output, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.entity, this.executionTime));
            return new BuildCacheStoreCommand.Result(){

                @Override
                public long getArtifactEntryCount() {
                    return packResult.getEntries();
                }
            };
        }
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> {
        private final BuildCacheKey cacheKey;
        private final CacheableEntity entity;
        private final Iterable<File> localState;
        private final BuildCacheLoadListener loadListener;

        private LoadCommand(BuildCacheKey cacheKey, CacheableEntity entity, Iterable<File> localState, BuildCacheLoadListener loadListener) {
            this.cacheKey = cacheKey;
            this.entity = entity;
            this.localState = localState;
            this.loadListener = loadListener;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> load(InputStream input) {
            this.loadListener.beforeLoad();
            try {
                final BuildCacheEntryPacker.UnpackResult unpackResult = DefaultBuildCacheCommandFactory.this.packer.unpack(this.entity, input, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createReader(this.entity));
                final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshots = this.snapshotUnpackedData(unpackResult.getSnapshots());
                LOGGER.debug("Unpacked trees for {} from cache.", (Object)this.entity.getDisplayName());
                BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> result = new BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata>(){

                    @Override
                    public long getArtifactEntryCount() {
                        return unpackResult.getEntries();
                    }

                    @Override
                    public BuildCacheCommandFactory.LoadMetadata getMetadata() {
                        return new BuildCacheCommandFactory.LoadMetadata(){

                            @Override
                            public OriginMetadata getOriginMetadata() {
                                return unpackResult.getOriginMetadata();
                            }

                            @Override
                            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getResultingSnapshots() {
                                return snapshots;
                            }
                        };
                    }
                };
                return result;
            }
            catch (Exception e2) {
                throw new BuildCacheException(String.format("Failed to unpack trees for %s", this.entity.getDisplayName()), e2);
            }
            finally {
                this.cleanLocalState();
            }
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotUnpackedData(Map<String, ? extends FileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            FingerprintingStrategy fingerprintingStrategy = AbsolutePathFingerprintingStrategy.IGNORE_MISSING;
            this.entity.visitTrees((treeName, type, root) -> {
                if (root == null) {
                    builder.put(treeName, fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                FileSystemLocationSnapshot treeSnapshot = (FileSystemLocationSnapshot)treeSnapshots.get(treeName);
                String internedAbsolutePath = DefaultBuildCacheCommandFactory.this.stringInterner.intern(root.getAbsolutePath());
                ArrayList<FileSystemLocationSnapshot> roots = new ArrayList<FileSystemLocationSnapshot>();
                if (treeSnapshot == null) {
                    builder.put(treeName, fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                switch (type) {
                    case FILE: {
                        if (treeSnapshot.getType() != FileType.RegularFile) {
                            throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", new Object[]{treeName, treeSnapshot.getType()}));
                        }
                        roots.add(treeSnapshot);
                        break;
                    }
                    case DIRECTORY: {
                        roots.add(treeSnapshot);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                builder.put(treeName, DefaultCurrentFileCollectionFingerprint.from(roots, fingerprintingStrategy));
            });
            return builder.build();
        }

        private void cleanLocalState() {
            for (File localStateFile : this.localState) {
                try {
                    this.remove(localStateFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", this.entity.getDisplayName(), localStateFile), ex);
                }
            }
        }

        private void remove(File file) throws IOException {
            if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    FileUtils.cleanDirectory(file);
                } else {
                    FileUtils.forceDelete(file);
                }
            }
        }
    }
}

