/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;

public class OriginMetadata {
    private final String buildInvocationId;
    private final long executionTime;

    public OriginMetadata(String buildInvocationId, long executionTime) {
        this.buildInvocationId = Preconditions.checkNotNull(buildInvocationId, "buildInvocationId");
        this.executionTime = executionTime;
    }

    public String getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        OriginMetadata that = (OriginMetadata)o2;
        return this.executionTime == that.executionTime && this.buildInvocationId.equals(that.buildInvocationId);
    }

    public int hashCode() {
        int result = this.buildInvocationId.hashCode();
        result = 31 * result + (int)(this.executionTime ^ this.executionTime >>> 32);
        return result;
    }

    public String toString() {
        return "OriginMetadata{buildInvocationId=" + this.buildInvocationId + ", executionTime=" + this.executionTime + '}';
    }
}

