/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Platform;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Strings {
    public static String nullToEmpty(String string) {
        return Platform.nullToEmpty(string);
    }

    public static String emptyToNull(String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String lenientFormat(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < args.length; ++i2) {
                args[i2] = Strings.lenientToString(args[i2]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i3 = 0;
        while (i3 < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i3++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i3 < args.length) {
            builder.append(" [");
            builder.append(args[i3++]);
            while (i3 < args.length) {
                builder.append(", ");
                builder.append(args[i3++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(Object o2) {
        try {
            return String.valueOf(o2);
        }
        catch (Exception e2) {
            String objectToString = o2.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o2));
            Logger.getLogger("com.gradle.maven.extension.internal.dep.com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e2);
            return "<" + objectToString + " threw " + e2.getClass().getName() + ">";
        }
    }
}

