/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.normalization.java.ApiClassExtractor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);

    private HashCode hashClassBytes(byte[] classBytes) {
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.emptySet());
        ClassReader reader = new ClassReader(classBytes);
        return extractor.extractApiClassFrom(reader).map(Hashing::hashBytes).orElse(null);
    }

    @Override
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        try {
            if (!this.isClassFile(fileSnapshot.getName())) {
                return null;
            }
            Path path = Paths.get(fileSnapshot.getAbsolutePath(), new String[0]);
            byte[] classBytes = Files.readAllBytes(path);
            return this.hashClassBytes(classBytes);
        }
        catch (Exception e2) {
            LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)fileSnapshot.getName(), (Object)e2);
            return fileSnapshot.getHash();
        }
    }

    @Override
    public HashCode hash(ZipEntry zipEntry) throws IOException {
        byte[] content;
        if (!this.isClassFile(zipEntry.getName())) {
            return null;
        }
        if (zipEntry.size() >= 0) {
            content = new byte[zipEntry.size()];
            ByteStreams.readFully(zipEntry.getInputStream(), content);
        } else {
            content = ByteStreams.toByteArray(zipEntry.getInputStream());
        }
        return this.hashClassBytes(content);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
    }
}

