/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Sets;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.AnnotationVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.FieldVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ModuleVisitor;
import java.util.Set;
import java.util.SortedSet;
import org.gradle.internal.normalization.java.impl.AnnotationAnnotationValue;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.ArrayAnnotationValue;
import org.gradle.internal.normalization.java.impl.ClassMember;
import org.gradle.internal.normalization.java.impl.EnumAnnotationValue;
import org.gradle.internal.normalization.java.impl.FieldMember;
import org.gradle.internal.normalization.java.impl.InnerClassMember;
import org.gradle.internal.normalization.java.impl.MethodMember;
import org.gradle.internal.normalization.java.impl.ParameterAnnotationMember;
import org.gradle.internal.normalization.java.impl.SimpleAnnotationValue;
import org.gradle.internal.normalization.java.impl.SortingAnnotationVisitor;

public class ApiMemberSelector
extends ClassVisitor {
    private final SortedSet<MethodMember> methods = Sets.newTreeSet();
    private final SortedSet<FieldMember> fields = Sets.newTreeSet();
    private final SortedSet<InnerClassMember> innerClasses = Sets.newTreeSet();
    private final String className;
    private final ClassVisitor apiMemberAdapter;
    private final boolean apiIncludesPackagePrivateMembers;
    private boolean isInnerClass;
    private ClassMember classMember;
    private boolean thisClassIsPrivateInnerClass;

    public ApiMemberSelector(String className, ClassVisitor apiMemberAdapter, boolean apiIncludesPackagePrivateMembers) {
        super(458752);
        this.className = className;
        this.apiMemberAdapter = apiMemberAdapter;
        this.apiIncludesPackagePrivateMembers = apiIncludesPackagePrivateMembers;
    }

    public boolean isPrivateInnerClass() {
        return this.thisClassIsPrivateInnerClass;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classMember = new ClassMember(version, access, name, signature, superName, interfaces);
        this.isInnerClass = (access & 0x20) == 32;
    }

    @Override
    public ModuleVisitor visitModule(String name, int access, String version) {
        return this.apiMemberAdapter.visitModule(name, access, version);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.apiMemberAdapter.visit(this.classMember.getVersion(), this.classMember.getAccess(), this.classMember.getName(), this.classMember.getSignature(), this.classMember.getSuperName(), this.classMember.getInterfaces());
        this.visitAnnotationMembers(this.classMember.getAnnotations());
        for (MethodMember method : this.methods) {
            MethodVisitor mv = this.apiMemberAdapter.visitMethod(method.getAccess(), method.getName(), method.getTypeDesc(), method.getSignature(), method.getExceptions().toArray(new String[0]));
            this.visitAnnotationMembers(mv, method.getAnnotations());
            this.visitAnnotationMembers(mv, method.getParameterAnnotations());
            mv.visitEnd();
        }
        for (FieldMember field : this.fields) {
            FieldVisitor fieldVisitor = this.apiMemberAdapter.visitField(field.getAccess(), field.getName(), field.getTypeDesc(), field.getSignature(), field.getValue());
            this.visitAnnotationMembers(fieldVisitor, field.getAnnotations());
            fieldVisitor.visitEnd();
        }
        for (InnerClassMember innerClass : this.innerClasses) {
            this.apiMemberAdapter.visitInnerClass(innerClass.getName(), innerClass.getOuterName(), innerClass.getInnerName(), innerClass.getAccess());
        }
        this.apiMemberAdapter.visitEnd();
    }

    private void visitAnnotationMembers(Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = this.apiMemberAdapter.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.visitAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void visitAnnotationMembers(MethodVisitor mv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = annotation instanceof ParameterAnnotationMember ? mv.visitParameterAnnotation(((ParameterAnnotationMember)annotation).getParameter(), annotation.getName(), annotation.isVisible()) : mv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.visitAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void visitAnnotationMembers(FieldVisitor fv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = fv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.visitAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void visitAnnotationValues(AnnotationMember annotation, AnnotationVisitor annotationVisitor) {
        for (AnnotationValue annotationValue : annotation.getValues()) {
            this.visitAnnotationValue(annotationVisitor, annotationValue);
        }
        annotationVisitor.visitEnd();
    }

    private void visitAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue<?> value) {
        String name = value.getName();
        if (value instanceof EnumAnnotationValue) {
            annotationVisitor.visitEnum(name, ((EnumAnnotationValue)value).getTypeDesc(), (String)value.getValue());
        } else if (value instanceof SimpleAnnotationValue) {
            annotationVisitor.visit(name, value.getValue());
        } else if (value instanceof ArrayAnnotationValue) {
            AnnotationValue[] values;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (AnnotationValue annotationValue : values = (AnnotationValue[])((ArrayAnnotationValue)value).getValue()) {
                this.visitAnnotationValue(arrayVisitor, annotationValue);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof AnnotationAnnotationValue) {
            AnnotationMember annotation = (AnnotationMember)((AnnotationAnnotationValue)value).getValue();
            AnnotationVisitor annVisitor = annotationVisitor.visitAnnotation(name, annotation.getName());
            this.visitAnnotationValues(annotation, annVisitor);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationMember ann = new AnnotationMember(desc, visible);
        this.classMember.addAnnotation(ann);
        return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            return null;
        }
        if (ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers) || "<init>".equals(name) && this.isInnerClass) {
            final MethodMember methodMember = new MethodMember(access, name, desc, signature, exceptions);
            this.methods.add(methodMember);
            return new MethodVisitor(458752){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationMember ann = new AnnotationMember(desc, visible);
                    methodMember.addAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    ParameterAnnotationMember ann = new ParameterAnnotationMember(desc, visible, parameter);
                    methodMember.addParameterAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitParameterAnnotation(parameter, desc, visible));
                }
            };
        }
        return null;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (ApiMemberSelector.isCandidateApiMember(access, this.apiIncludesPackagePrivateMembers)) {
            Object keepValue = (access & 8) == 8 && (access & 0x10) == 16 ? value : null;
            final FieldMember fieldMember = new FieldMember(access, name, signature, desc, keepValue);
            this.fields.add(fieldMember);
            return new FieldVisitor(458752){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationMember ann = new AnnotationMember(desc, visible);
                    fieldMember.addAnnotation(ann);
                    return new SortingAnnotationVisitor(ann, super.visitAnnotation(desc, visible));
                }
            };
        }
        return null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        boolean privateInnerClass;
        boolean bl = privateInnerClass = (access & 2) != 0;
        if (name.equals(this.className) && privateInnerClass) {
            this.thisClassIsPrivateInnerClass = true;
        }
        if (outerName == null || innerName == null || privateInnerClass) {
            return;
        }
        if (!this.apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(access)) {
            return;
        }
        this.innerClasses.add(new InnerClassMember(access, name, outerName, innerName));
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public static boolean isCandidateApiMember(int access, boolean apiIncludesPackagePrivateMembers) {
        return ApiMemberSelector.isPublicMember(access) || ApiMemberSelector.isProtectedMember(access) || apiIncludesPackagePrivateMembers && ApiMemberSelector.isPackagePrivateMember(access);
    }

    private static boolean isPublicMember(int access) {
        return (access & 1) == 1;
    }

    private static boolean isProtectedMember(int access) {
        return (access & 4) == 4;
    }

    private static boolean isPackagePrivateMember(int access) {
        return (access & 7) == 0;
    }
}

