/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.classpath.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.gradle.api.internal.changedetection.state.CachingRegularFileHasher;
import org.gradle.api.internal.changedetection.state.FingerprintCache;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.CompleteDirectorySnapshot;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class ClasspathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    private final NonZipFingerprintingStrategy nonZipFingerprintingStrategy;
    private final ResourceFilter classpathResourceFilter;
    private final ResourceHasher classpathResourceHasher;
    private final RegularFileHasher zipHasher;
    private final Interner<String> stringInterner;

    private ClasspathFingerprintingStrategy(String identifier, NonZipFingerprintingStrategy nonZipFingerprintingStrategy, ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter, Interner<String> stringInterner, FingerprintCache zipFingerprintCache) {
        super(identifier);
        this.nonZipFingerprintingStrategy = nonZipFingerprintingStrategy;
        this.classpathResourceFilter = classpathResourceFilter;
        this.classpathResourceHasher = classpathResourceHasher;
        this.stringInterner = stringInterner;
        this.zipHasher = new CachingRegularFileHasher(new ZipHasher(classpathResourceHasher, classpathResourceFilter), zipFingerprintCache);
    }

    public static ClasspathFingerprintingStrategy runtimeClasspath(ResourceFilter classpathResourceFilter, ResourceHasher runtimeClasspathResourceHasher, Interner<String> stringInterner, FingerprintCache zipFingerprintCache) {
        return new ClasspathFingerprintingStrategy("CLASSPATH", NonZipFingerprintingStrategy.USE_FILE_HASH, runtimeClasspathResourceHasher, classpathResourceFilter, stringInterner, zipFingerprintCache);
    }

    public static ClasspathFingerprintingStrategy compileClasspath(ResourceHasher classpathResourceHasher, Interner<String> stringInterner, FingerprintCache zipFingerprintCache) {
        return new ClasspathFingerprintingStrategy("COMPILE_CLASSPATH", NonZipFingerprintingStrategy.IGNORE, classpathResourceHasher, ResourceFilter.FILTER_NOTHING, stringInterner, zipFingerprintCache);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(Iterable<? extends FileSystemSnapshot> roots) {
        ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder = ImmutableMap.builder();
        HashSet<String> processedEntries = new HashSet<String>();
        for (FileSystemSnapshot fileSystemSnapshot : roots) {
            ClasspathFingerprintVisitor fingerprintVisitor = new ClasspathFingerprintVisitor(processedEntries, builder);
            fileSystemSnapshot.accept(new ClasspathContentFingerprintingVisitor(fingerprintVisitor));
        }
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.KEEP_ORDER;
    }

    private HashCode fingerprintRootFile(RegularFileSnapshot fileSnapshot) {
        if (ZipHasher.isZipFile(fileSnapshot.getName())) {
            return this.zipHasher.hash(fileSnapshot);
        }
        return this.nonZipFingerprintingStrategy.determineNonZipFingerprint(fileSnapshot.getHash());
    }

    private class ClasspathFingerprintVisitor {
        private final RelativePathStringTracker relativePathStringTracker;
        private final HashSet<String> processedEntries;
        private final ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder;

        public ClasspathFingerprintVisitor(HashSet<String> processedEntries, ImmutableMap.Builder<String, FileSystemLocationFingerprint> builder) {
            this.processedEntries = processedEntries;
            this.builder = builder;
            this.relativePathStringTracker = new RelativePathStringTracker();
        }

        public boolean preVisitDirectory(CompleteFileSystemLocationSnapshot directorySnapshot) {
            this.relativePathStringTracker.enter(directorySnapshot);
            return true;
        }

        public void visit(CompleteFileSystemLocationSnapshot fileSnapshot, HashCode normalizedContentHash) {
            String absolutePath = fileSnapshot.getAbsolutePath();
            if (this.processedEntries.add(absolutePath)) {
                FileSystemLocationFingerprint fingerprint = this.relativePathStringTracker.isRoot() ? IgnoredPathFileSystemLocationFingerprint.create(fileSnapshot.getType(), normalizedContentHash) : this.createFileFingerprint(fileSnapshot, normalizedContentHash);
                this.builder.put(absolutePath, fingerprint);
            }
        }

        private FileSystemLocationFingerprint createFileFingerprint(CompleteFileSystemLocationSnapshot snapshot, HashCode content) {
            this.relativePathStringTracker.enter(snapshot);
            DefaultFileSystemLocationFingerprint fingerprint = new DefaultFileSystemLocationFingerprint(ClasspathFingerprintingStrategy.this.stringInterner.intern(this.relativePathStringTracker.getRelativePathString()), FileType.RegularFile, content);
            this.relativePathStringTracker.leave();
            return fingerprint;
        }

        public void postVisitDirectory() {
            this.relativePathStringTracker.leave();
        }
    }

    private class ClasspathContentFingerprintingVisitor
    implements FileSystemSnapshotVisitor {
        private final ClasspathFingerprintVisitor delegate;
        private final RelativePathSegmentsTracker relativePathSegmentsTracker = new RelativePathSegmentsTracker();
        private final Supplier<String[]> relativePathFactory = () -> Iterables.toArray(this.relativePathSegmentsTracker.getRelativePath(), String.class);

        public ClasspathContentFingerprintingVisitor(ClasspathFingerprintVisitor delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean preVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.enter(directorySnapshot);
            return this.delegate.preVisitDirectory(directorySnapshot);
        }

        @Override
        public void visitFile(CompleteFileSystemLocationSnapshot fileSnapshot) {
            HashCode normalizedContent;
            if (fileSnapshot.getType() == FileType.RegularFile && (normalizedContent = this.fingerprintFile((RegularFileSnapshot)fileSnapshot)) != null) {
                this.delegate.visit(fileSnapshot, normalizedContent);
            }
        }

        private HashCode fingerprintFile(RegularFileSnapshot fileSnapshot) {
            return this.relativePathSegmentsTracker.isRoot() ? ClasspathFingerprintingStrategy.this.fingerprintRootFile(fileSnapshot) : this.fingerprintTreeFile(fileSnapshot);
        }

        private HashCode fingerprintTreeFile(RegularFileSnapshot fileSnapshot) {
            this.relativePathSegmentsTracker.enter(fileSnapshot);
            boolean shouldBeIgnored = ClasspathFingerprintingStrategy.this.classpathResourceFilter.shouldBeIgnored(this.relativePathFactory);
            this.relativePathSegmentsTracker.leave();
            if (shouldBeIgnored) {
                return null;
            }
            if (ZipHasher.isZipFile(fileSnapshot.getName())) {
                return ClasspathFingerprintingStrategy.this.zipHasher.hash(fileSnapshot);
            }
            return ClasspathFingerprintingStrategy.this.classpathResourceHasher.hash(fileSnapshot);
        }

        @Override
        public void postVisitDirectory(CompleteDirectorySnapshot directorySnapshot) {
            this.relativePathSegmentsTracker.leave();
            this.delegate.postVisitDirectory();
        }
    }

    public static enum NonZipFingerprintingStrategy {
        IGNORE{

            @Override
            public HashCode determineNonZipFingerprint(HashCode original) {
                return null;
            }
        }
        ,
        USE_FILE_HASH{

            @Override
            public HashCode determineNonZipFingerprint(HashCode original) {
                return original;
            }
        };


        public abstract HashCode determineNonZipFingerprint(HashCode var1);
    }
}

