/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.InjectableValues;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MappingJsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.Module;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.Deserializers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.Serializers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.RootNameLookup;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectMapper
extends ObjectCodec
implements Serializable {
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(null, DEFAULT_ANNOTATION_INTROSPECTOR, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), null, Base64Variants.getDefaultVariant(), LaissezFaireSubTypeValidator.instance);
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final ConfigOverrides _configOverrides;
    protected SimpleMixInResolver _mixIns;
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected Set<Object> _registeredModuleTypes;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jf) {
        this(jf, null, null);
    }

    public ObjectMapper(JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        SimpleMixInResolver mixins;
        if (jf == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = jf;
            if (jf.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        RootNameLookup rootNames = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        this._mixIns = mixins = new SimpleMixInResolver(null);
        BaseSettings base = DEFAULT_BASE.withClassIntrospector(this.defaultClassIntrospector());
        this._configOverrides = new ConfigOverrides();
        this._serializationConfig = new SerializationConfig(base, this._subtypeResolver, mixins, rootNames, this._configOverrides);
        this._deserializationConfig = new DeserializationConfig(base, this._subtypeResolver, mixins, rootNames, this._configOverrides);
        boolean needOrder = this._jsonFactory.requiresPropertyOrdering();
        if (needOrder ^ this._serializationConfig.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)) {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, needOrder);
        }
        this._serializerProvider = sp == null ? new DefaultSerializerProvider.Impl() : sp;
        this._deserializationContext = dc == null ? new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance) : dc;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    protected ClassIntrospector defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    protected ObjectReader _newReader(DeserializationConfig config) {
        return new ObjectReader(this, config);
    }

    protected ObjectReader _newReader(DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        return new ObjectReader(this, config, valueType, valueToUpdate, schema, injectableValues);
    }

    protected ObjectWriter _newWriter(SerializationConfig config) {
        return new ObjectWriter(this, config);
    }

    protected ObjectWriter _newWriter(SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        return new ObjectWriter(this, config, rootType, pp);
    }

    public ObjectMapper registerModule(Module module) {
        Object typeId;
        this._assertNotNull("module", module);
        String name = module.getModuleName();
        if (name == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        Version version = module.version();
        if (version == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        for (Module module2 : module.getDependencies()) {
            this.registerModule(module2);
        }
        if (this.isEnabled(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS) && (typeId = module.getTypeId()) != null) {
            if (this._registeredModuleTypes == null) {
                this._registeredModuleTypes = new LinkedHashSet<Object>();
            }
            if (!this._registeredModuleTypes.add(typeId)) {
                return this;
            }
        }
        module.setupModule(new Module.SetupContext(){

            @Override
            public void addDeserializers(Deserializers d2) {
                DeserializerFactory df = ObjectMapper.this._deserializationContext._factory.withAdditionalDeserializers(d2);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(df);
            }

            @Override
            public void addKeyDeserializers(KeyDeserializers d2) {
                DeserializerFactory df = ObjectMapper.this._deserializationContext._factory.withAdditionalKeyDeserializers(d2);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(df);
            }

            @Override
            public void addBeanDeserializerModifier(BeanDeserializerModifier modifier) {
                DeserializerFactory df = ObjectMapper.this._deserializationContext._factory.withDeserializerModifier(modifier);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(df);
            }

            @Override
            public void addSerializers(Serializers s2) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withAdditionalSerializers(s2);
            }

            @Override
            public void addKeySerializers(Serializers s2) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withAdditionalKeySerializers(s2);
            }

            @Override
            public void addBeanSerializerModifier(BeanSerializerModifier modifier) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withSerializerModifier(modifier);
            }

            @Override
            public void addAbstractTypeResolver(AbstractTypeResolver resolver) {
                DeserializerFactory df = ObjectMapper.this._deserializationContext._factory.withAbstractTypeResolver(resolver);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(df);
            }

            @Override
            public void addValueInstantiators(ValueInstantiators instantiators) {
                DeserializerFactory df = ObjectMapper.this._deserializationContext._factory.withValueInstantiators(instantiators);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(df);
            }

            @Override
            public void registerSubtypes(NamedType ... subtypes) {
                ObjectMapper.this.registerSubtypes(subtypes);
            }

            @Override
            public void setMixInAnnotations(Class<?> target, Class<?> mixinSource) {
                ObjectMapper.this.addMixIn(target, mixinSource);
            }

            @Override
            public void setNamingStrategy(PropertyNamingStrategy naming) {
                ObjectMapper.this.setPropertyNamingStrategy(naming);
            }
        });
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public ObjectMapper addMixIn(Class<?> target, Class<?> mixinSource) {
        this._mixIns.addLocalDefinition(target, mixinSource);
        return this;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy s2) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(s2);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(s2);
        return this;
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include incl) {
        this.setPropertyInclusion(JsonInclude.Value.construct(incl, incl));
        return this;
    }

    @Deprecated
    public ObjectMapper setPropertyInclusion(JsonInclude.Value incl) {
        return this.setDefaultPropertyInclusion(incl);
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Value incl) {
        this._configOverrides.setDefaultInclusion(incl);
        return this;
    }

    public void registerSubtypes(NamedType ... types) {
        this.getSubtypeResolver().registerSubtypes(types);
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    @Override
    @Deprecated
    public JsonFactory getJsonFactory() {
        return this.getFactory();
    }

    public boolean isEnabled(MapperFeature f2) {
        return this._serializationConfig.isEnabled(f2);
    }

    public ObjectMapper configure(MapperFeature f2, boolean state) {
        this._serializationConfig = state ? (SerializationConfig)this._serializationConfig.with(f2) : (SerializationConfig)this._serializationConfig.without(f2);
        this._deserializationConfig = state ? (DeserializationConfig)this._deserializationConfig.with(f2) : (DeserializationConfig)this._deserializationConfig.without(f2);
        return this;
    }

    public ObjectMapper configure(SerializationFeature f2, boolean state) {
        this._serializationConfig = state ? this._serializationConfig.with(f2) : this._serializationConfig.without(f2);
        return this;
    }

    public ObjectMapper disable(SerializationFeature f2) {
        this._serializationConfig = this._serializationConfig.without(f2);
        return this;
    }

    @Override
    public <T> T readValue(JsonParser p2, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        this._assertNotNull("p", p2);
        return (T)this._readValue(this.getDeserializationConfig(), p2, this._typeFactory.constructType(valueType));
    }

    @Override
    public <T> T readValue(JsonParser p2, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        this._assertNotNull("p", p2);
        return (T)this._readValue(this.getDeserializationConfig(), p2, this._typeFactory.constructType(valueTypeRef));
    }

    @Override
    public void writeValue(JsonGenerator g2, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._assertNotNull("g", g2);
        SerializationConfig config = this.getSerializationConfig();
        if (config.isEnabled(SerializationFeature.INDENT_OUTPUT) && g2.getPrettyPrinter() == null) {
            g2.setPrettyPrinter(config.constructDefaultPrettyPrinter());
        }
        if (config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseableValue(g2, value, config);
        } else {
            this._serializerProvider(config).serializeValue(g2, value);
            if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g2.flush();
            }
        }
    }

    public ObjectWriter writer() {
        return this._newWriter(this.getSerializationConfig());
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig config = this.getSerializationConfig();
        return this._newWriter(config, null, config.getDefaultPrettyPrinter());
    }

    public ObjectReader reader() {
        return this._newReader(this.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader readerFor(Class<?> type) {
        return this._newReader(this.getDeserializationConfig(), this._typeFactory.constructType(type), null, null, this._injectableValues);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig config) {
        return this._serializerProvider.createInstance(config, this._serializerFactory);
    }

    private final void _writeCloseableValue(JsonGenerator g2, Object value, SerializationConfig cfg) throws IOException {
        Closeable toClose = (Closeable)value;
        try {
            this._serializerProvider(cfg).serializeValue(g2, value);
            if (cfg.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g2.flush();
            }
        }
        catch (Exception e2) {
            ClassUtil.closeOnFailAndThrowAsIOE(null, toClose, e2);
            return;
        }
        toClose.close();
    }

    protected Object _readValue(DeserializationConfig cfg, JsonParser p2, JavaType valueType) throws IOException {
        Object result;
        JsonToken t2 = this._initForReading(p2, valueType);
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2, cfg);
        if (t2 == JsonToken.VALUE_NULL) {
            result = this._findRootDeserializer(ctxt, valueType).getNullValue(ctxt);
        } else if (t2 == JsonToken.END_ARRAY || t2 == JsonToken.END_OBJECT) {
            result = null;
        } else {
            JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
            result = cfg.useRootWrapping() ? this._unwrapAndDeserialize(p2, ctxt, cfg, valueType, deser) : deser.deserialize(p2, ctxt);
        }
        p2.clearCurrentToken();
        if (cfg.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p2, ctxt, valueType);
        }
        return result;
    }

    protected Object _unwrapAndDeserialize(JsonParser p2, DeserializationContext ctxt, DeserializationConfig config, JavaType rootType, JsonDeserializer<Object> deser) throws IOException {
        String actualName;
        PropertyName expRootName = config.findRootName(rootType);
        String expSimpleName = expRootName.getSimpleName();
        if (p2.getCurrentToken() != JsonToken.START_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (p2.nextToken() != JsonToken.FIELD_NAME) {
            ctxt.reportWrongTokenException(rootType, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (!expSimpleName.equals(actualName = p2.getCurrentName())) {
            ctxt.reportPropertyInputMismatch(rootType, actualName, "Root name '%s' does not match expected ('%s') for type %s", actualName, expSimpleName, rootType);
        }
        p2.nextToken();
        Object result = deser.deserialize(p2, ctxt);
        if (p2.nextToken() != JsonToken.END_OBJECT) {
            ctxt.reportWrongTokenException(rootType, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(p2, ctxt, rootType);
        }
        return result;
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser p2, DeserializationConfig cfg) {
        return this._deserializationContext.createInstance(cfg, p2, this._injectableValues);
    }

    protected JsonToken _initForReading(JsonParser p2, JavaType targetType) throws IOException {
        this._deserializationConfig.initialize(p2);
        JsonToken t2 = p2.getCurrentToken();
        if (t2 == null && (t2 = p2.nextToken()) == null) {
            throw MismatchedInputException.from(p2, targetType, "No content to map due to end-of-input");
        }
        return t2;
    }

    protected final void _verifyNoTrailingTokens(JsonParser p2, DeserializationContext ctxt, JavaType bindType) throws IOException {
        JsonToken t2 = p2.nextToken();
        if (t2 != null) {
            Class<?> bt = ClassUtil.rawClass(bindType);
            ctxt.reportTrailingTokens(bt, p2, t2);
        }
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt, JavaType valueType) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(valueType);
        if (deser == null) {
            return (JsonDeserializer)ctxt.reportBadDefinition(valueType, "Cannot find a deserializer for type " + valueType);
        }
        this._rootDeserializers.put(valueType, deser);
        return deser;
    }

    protected final void _assertNotNull(String paramName, Object src) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", paramName));
        }
    }
}

