/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelNode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InlineList
extends SpelNodeImpl {
    private TypedValue constant;

    public InlineList(int pos, SpelNodeImpl ... args) {
        super(pos, args);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        boolean isConstant = true;
        int max = this.getChildCount();
        for (int c2 = 0; c2 < max; ++c2) {
            SpelNode child = this.getChild(c2);
            if (child instanceof Literal) continue;
            if (child instanceof InlineList) {
                InlineList inlineList = (InlineList)child;
                if (inlineList.isConstant()) continue;
                isConstant = false;
                continue;
            }
            isConstant = false;
        }
        if (isConstant) {
            ArrayList<Object> constantList = new ArrayList<Object>();
            int childcount = this.getChildCount();
            for (int c3 = 0; c3 < childcount; ++c3) {
                SpelNode child = this.getChild(c3);
                if (child instanceof Literal) {
                    constantList.add(((Literal)child).getLiteralValue().getValue());
                    continue;
                }
                if (!(child instanceof InlineList)) continue;
                constantList.add(((InlineList)child).getConstantValue());
            }
            this.constant = new TypedValue(Collections.unmodifiableList(constantList));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        int childCount = this.getChildCount();
        for (int c2 = 0; c2 < childCount; ++c2) {
            returnValue.add(this.getChild(c2).getValue(expressionState));
        }
        return new TypedValue(returnValue);
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("{");
        int count = this.getChildCount();
        for (int c2 = 0; c2 < count; ++c2) {
            if (c2 > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(c2).toStringAST());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public List<Object> getConstantValue() {
        Assert.state(this.constant != null, "No constant");
        return (List)this.constant.getValue();
    }

    @Override
    public boolean isCompilable() {
        return this.isConstant();
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow codeflow) {
        String constantFieldName = "inlineList$" + codeflow.nextFieldId();
        String className = codeflow.getClassName();
        codeflow.registerNewField((cw, cflow) -> cw.visitField(26, constantFieldName, "Ljava/util/List;", null, null));
        codeflow.registerNewClinit((mVisitor, cflow) -> this.generateClinitCode(className, constantFieldName, mVisitor, cflow, false));
        mv.visitFieldInsn(178, className, constantFieldName, "Ljava/util/List;");
        codeflow.pushDescriptor("Ljava/util/List");
    }

    void generateClinitCode(String clazzname, String constantFieldName, MethodVisitor mv, CodeFlow codeflow, boolean nested) {
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        if (!nested) {
            mv.visitFieldInsn(179, clazzname, constantFieldName, "Ljava/util/List;");
        }
        int childCount = this.getChildCount();
        for (int c2 = 0; c2 < childCount; ++c2) {
            if (!nested) {
                mv.visitFieldInsn(178, clazzname, constantFieldName, "Ljava/util/List;");
            } else {
                mv.visitInsn(89);
            }
            if (this.children[c2] instanceof InlineList) {
                ((InlineList)this.children[c2]).generateClinitCode(clazzname, constantFieldName, mv, codeflow, true);
            } else {
                this.children[c2].generateCode(mv, codeflow);
                String lastDesc = codeflow.lastDescriptor();
                if (CodeFlow.isPrimitive(lastDesc)) {
                    CodeFlow.insertBoxIfNecessary(mv, lastDesc.charAt(0));
                }
            }
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
        }
    }
}

