/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.d;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class a {
    private static final Duration a = Duration.ofDays(30L);
    private static final Duration b = Duration.ofDays(1L);

    public static a a(File dir, Instant now) {
        ExecutorService executor = Executors.newSingleThreadExecutor(r2 -> new Thread(r2, "gradle-enterprise-data-dir-cleaner"));
        Future<List> future = executor.submit(() -> {
            ArrayList<b> events = new ArrayList<b>();
            com.gradle.scan.plugin.internal.d.a.a(dir.toPath(), now, events);
            return events;
        });
        executor.shutdown();
        return () -> {
            try {
                return (List)future.get();
            }
            catch (Exception e2) {
                return Collections.singletonList(new b("Data dir clean failed", e2));
            }
        };
    }

    private static void a(Path dir, final Instant now, final List<b> events) {
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                public FileVisitResult a(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult b(Path file, BasicFileAttributes attrs) {
                    try {
                        if (com.gradle.scan.plugin.internal.d.a.b(now, attrs.lastModifiedTime().toInstant(), a)) {
                            events.add(new b("Deleting old file " + file, null));
                            Files.delete(file);
                        }
                    }
                    catch (Exception e2) {
                        events.add(new b("Failed to test or delete file " + file, e2));
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult a(Path file, IOException exc) {
                    events.add(new b("Failed to visit file " + file, exc));
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult b(Path dir, IOException exc) {
                    try {
                        if (com.gradle.scan.plugin.internal.d.a.b(now, Files.getLastModifiedTime(dir, new LinkOption[0]).toInstant(), b) && com.gradle.scan.plugin.internal.d.a.b(dir)) {
                            events.add(new b("Deleting old dir " + dir, null));
                            Files.delete(dir);
                        }
                    }
                    catch (Exception e2) {
                        events.add(new b("Failed to test or delete dir " + dir, e2));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                    return this.b((Path)object, iOException);
                }

                @Override
                public /* synthetic */ FileVisitResult visitFileFailed(Object object, IOException iOException) throws IOException {
                    return this.a((Path)object, iOException);
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.b((Path)object, basicFileAttributes);
                }

                @Override
                public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.a((Path)object, basicFileAttributes);
                }
            });
        }
        catch (IOException e2) {
            events.add(new b("File tree walk failed", e2));
        }
    }

    private static boolean b(Instant now, Instant instant, Duration fileRetentionPeriod) {
        return instant.plus(fileRetentionPeriod).isBefore(now);
    }

    private static boolean b(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static interface a {
        public List<b> await();

        default public void a(com.gradle.scan.plugin.internal.i.b logging) {
            for (b event : this.await()) {
                if (event.b == null) {
                    logging.d(event.a);
                    continue;
                }
                logging.d(event.a, event.b);
            }
        }
    }

    public static final class b {
        public final String a;
        public final Throwable b;

        b(String message, Throwable exception) {
            this.a = message;
            this.b = exception;
        }
    }
}

