/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.k.a;

import com.gradle.scan.plugin.a.a;
import com.gradle.scan.plugin.internal.e;
import com.gradle.scan.plugin.internal.k.a.b;
import com.gradle.scan.plugin.internal.k.a.d;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public final class c {
    @SuppressFBWarnings(justification="Forked process command is controlled")
    public static boolean a(com.gradle.scan.plugin.internal.i.b logger, File globalUploadFailureLog, File dataDir, d spec) {
        try {
            Optional<Path> javaPath = c.a();
            if (!javaPath.isPresent()) {
                b.a(logger, globalUploadFailureLog, "Cannot find path to java executable.");
                return false;
            }
            Optional<Path> backgroundUploadJar = c.a(logger, globalUploadFailureLog, dataDir);
            if (!backgroundUploadJar.isPresent()) {
                return false;
            }
            Process process = new ProcessBuilder(new String[0]).command(c.a(logger, javaPath.get(), backgroundUploadJar.get())).redirectErrorStream(true).redirectOutput(spec.a.d()).start();
            try (ObjectOutputStream out = new ObjectOutputStream(process.getOutputStream());){
                d.a((ObjectOutput)out, spec);
            }
            return c.a(process, spec.a.a());
        }
        catch (Exception e2) {
            b.a(logger, globalUploadFailureLog, "Problem forking build scan upload", e2);
            return false;
        }
    }

    private static boolean a(Process process, File sentinelFile) {
        long start = System.nanoTime();
        Duration timeout = Duration.ofMillis(Long.getLong("com.gradle.backgroundUpload.forkedProcessWaitMillis", 5000L));
        Duration waitingFor = Duration.ZERO;
        while (waitingFor.compareTo(timeout) < 0) {
            if (sentinelFile.exists()) {
                sentinelFile.delete();
                return true;
            }
            if (!process.isAlive()) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                return true;
            }
            waitingFor = Duration.ofNanos(System.nanoTime() - start);
        }
        return false;
    }

    private static List<String> a(com.gradle.scan.plugin.internal.i.b logger, Path javaPath, Path backgroundUploadJar) {
        Long syntheticSleep;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaPath.toFile().getAbsolutePath());
        if (Boolean.getBoolean("com.gradle.backgroundUpload.debug")) {
            logger.b("Waiting for debugger to attach on port 5006");
            commands.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5006");
        }
        if (Boolean.getBoolean("com.gradle.backgroundUpload.forkedProcessSyntheticError")) {
            commands.add("-Dcom.gradle.backgroundUpload.forkedProcessSyntheticError=true");
        }
        if ((syntheticSleep = Long.getLong("com.gradle.backgroundUpload.forkedProcessSyntheticSleepMillis")) != null) {
            commands.add("-Dcom.gradle.backgroundUpload.forkedProcessSyntheticSleepMillis=" + syntheticSleep);
        }
        commands.add("-jar");
        commands.add(backgroundUploadJar.toFile().getAbsolutePath());
        return commands;
    }

    private static Optional<Path> a() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return Optional.empty();
        }
        String javaExecutable = com.gradle.scan.plugin.internal.c.e.a.a().b() ? "java.exe" : "java";
        Path javaPath = Paths.get(javaHome, "bin", javaExecutable);
        if (!javaPath.toFile().exists()) {
            return Optional.empty();
        }
        return Optional.of(javaPath);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    private static Optional<Path> a(com.gradle.scan.plugin.internal.i.b logger, File globalUploadFailureLog, File dataDir) {
        Path unpackedJar;
        block22: {
            unpackedJar = new File(dataDir, "gradle-build-scan-background-upload.jar").toPath();
            if (Files.exists(unpackedJar, new LinkOption[0])) {
                return Optional.of(unpackedJar);
            }
            URL jarUrl = a.class.getResource("/com/gradle/scan/background-upload.jar.embed");
            if (jarUrl == null) {
                b.a(logger, globalUploadFailureLog, "Could not find background upload JAR.");
                return Optional.empty();
            }
            if (!dataDir.mkdirs() && !dataDir.isDirectory()) {
                b.a(logger, globalUploadFailureLog, "Could not create directory " + dataDir.getAbsolutePath() + ".");
                return Optional.empty();
            }
            Path tmpUnpackedJar = new File(unpackedJar.toAbsolutePath() + "." + UUID.randomUUID().toString()).toPath();
            try (InputStream in = jarUrl.openStream();
                 OutputStream out = Files.newOutputStream(tmpUnpackedJar, new OpenOption[0]);){
                e.a(in, out);
            }
            catch (IOException e2) {
                b.a(logger, globalUploadFailureLog, "Failed to unpack background upload JAR", e2);
                return Optional.empty();
            }
            try {
                Files.move(tmpUnpackedJar, unpackedJar, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e3) {
                if (Files.exists(unpackedJar, new LinkOption[0])) break block22;
                b.a(logger, globalUploadFailureLog, "Failed to move tmp background upload JAR", e3);
                try {
                    Files.deleteIfExists(tmpUnpackedJar);
                }
                catch (IOException e2) {
                    b.a(logger, globalUploadFailureLog, "Failed to delete tmp background upload JAR", e3);
                }
                return Optional.empty();
            }
        }
        return Optional.of(unpackedJar);
    }
}

