/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.j.a;

import com.gradle.scan.plugin.internal.c.e.a;
import com.gradle.scan.plugin.internal.h.b;
import com.gradle.scan.plugin.internal.j.a.e;
import com.gradle.scan.plugin.publish.BuildScanForkedUploadMain;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class d {
    @SuppressFBWarnings(justification="Forked process command is controlled")
    public static boolean a(b logger, e spec) {
        try {
            Optional<Path> javaPath = d.a();
            if (!javaPath.isPresent()) {
                logger.b("Cannot find path to java executable.");
                return false;
            }
            Optional<Path> buildAgentJar = d.b();
            if (!buildAgentJar.isPresent()) {
                logger.b("Cannot find path to Gradle Enterprise jar.");
                return false;
            }
            Process process = new ProcessBuilder(new String[0]).command(d.a(logger, javaPath.get(), buildAgentJar.get())).redirectErrorStream(true).redirectOutput(spec.a.d()).start();
            try (ObjectOutputStream out = new ObjectOutputStream(process.getOutputStream());){
                e.a((ObjectOutput)out, spec);
            }
            return d.a(spec.a.a());
        }
        catch (Exception e2) {
            logger.b("Problem forking build scan upload", e2);
            return false;
        }
    }

    private static boolean a(File sentinelFile) {
        long start = System.nanoTime();
        Duration timeout = Duration.ofSeconds(5L);
        Duration waitingFor = Duration.ZERO;
        while (waitingFor.compareTo(timeout) < 0) {
            if (sentinelFile.exists()) {
                sentinelFile.delete();
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                return true;
            }
            waitingFor = Duration.ofNanos(System.nanoTime() - start);
        }
        return false;
    }

    private static List<String> a(b logger, Path javaPath, Path buildAgentJar) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(javaPath.toFile().getAbsolutePath());
        if (Boolean.getBoolean("com.gradle.backgroundUpload.debug")) {
            logger.b("Waiting for debugger to attach on port 5006");
            commands.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:5006");
        }
        if (Boolean.getBoolean("com.gradle.backgroundUpload.forkedProcessSyntheticError")) {
            commands.add("-Dcom.gradle.backgroundUpload.forkedProcessSyntheticError=true");
        }
        commands.add("-cp");
        commands.add(buildAgentJar.toFile().getAbsolutePath());
        commands.add(BuildScanForkedUploadMain.class.getName());
        return commands;
    }

    private static Optional<Path> a() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return Optional.empty();
        }
        String javaExecutable = a.a().b() ? "java.exe" : "java";
        Path javaPath = Paths.get(javaHome, "bin", javaExecutable);
        if (!javaPath.toFile().exists()) {
            return Optional.empty();
        }
        return Optional.of(javaPath);
    }

    private static Optional<Path> b() {
        ProtectionDomain protectionDomain = BuildScanForkedUploadMain.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return Optional.empty();
        }
        URL location = codeSource.getLocation();
        String protocol = location.getProtocol();
        if (protocol == null || !protocol.equals("file")) {
            return Optional.empty();
        }
        try {
            return Optional.of(Paths.get(location.toURI()));
        }
        catch (URISyntaxException e2) {
            return Optional.empty();
        }
    }
}

