/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginMetadataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginMetadataFactory.class);
    private final File rootDir;
    private final String userName;
    private final String operatingSystem;
    private final String currentBuildInvocationId;
    private final PropertiesConfigurator additionalProperties;
    private final HostnameLookup hostnameLookup;

    public OriginMetadataFactory(File rootDir, String userName, String operatingSystem, String currentBuildInvocationId, PropertiesConfigurator additionalProperties, HostnameLookup hostnameLookup) {
        this.rootDir = rootDir;
        this.userName = userName;
        this.operatingSystem = operatingSystem;
        this.additionalProperties = additionalProperties;
        this.currentBuildInvocationId = currentBuildInvocationId;
        this.hostnameLookup = hostnameLookup;
    }

    public OriginWriter createWriter(final CacheableEntity entry, final long elapsedTime) {
        return new OriginWriter(){

            @Override
            public void execute(OutputStream outputStream) throws IOException {
                Properties properties = new Properties();
                properties.setProperty("buildInvocationId", OriginMetadataFactory.this.currentBuildInvocationId);
                properties.setProperty("type", entry.getClass().getCanonicalName());
                properties.setProperty("identity", entry.getIdentity());
                properties.setProperty("creationTime", Long.toString(System.currentTimeMillis()));
                properties.setProperty("executionTime", Long.toString(elapsedTime));
                properties.setProperty("rootPath", OriginMetadataFactory.this.rootDir.getAbsolutePath());
                properties.setProperty("operatingSystem", OriginMetadataFactory.this.operatingSystem);
                properties.setProperty("hostName", OriginMetadataFactory.this.hostnameLookup.getHostname());
                properties.setProperty("userName", OriginMetadataFactory.this.userName);
                OriginMetadataFactory.this.additionalProperties.configure(properties);
                properties.store(outputStream, "Generated origin information");
            }
        };
    }

    public OriginReader createReader(final CacheableEntity entry) {
        return new OriginReader(){

            @Override
            public OriginMetadata execute(InputStream inputStream) throws IOException {
                Properties properties = new Properties();
                properties.load(inputStream);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Origin for {}: {}", (Object)entry.getDisplayName(), (Object)properties);
                }
                String originBuildInvocationId = properties.getProperty("buildInvocationId");
                String executionTimeAsString = properties.getProperty("executionTime");
                if (originBuildInvocationId == null || executionTimeAsString == null) {
                    throw new IllegalStateException("Cached result format error, corrupted origin metadata");
                }
                long originalExecutionTime = Long.parseLong(executionTimeAsString);
                return new OriginMetadata(originBuildInvocationId, originalExecutionTime);
            }
        };
    }

    public static interface HostnameLookup {
        public String getHostname();
    }

    public static interface PropertiesConfigurator {
        public void configure(Properties var1);
    }
}

